Liferay.Loader.define('frontend-js-metal-web$incremental-dom-string@0.0.2/src/core', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /**
   * An array used to store the strings generated by calls to
   * elementOpen, elementOpenStart, elementOpenEnd, elementEnd and elementVoid
   */
  let buffer = [];

  /** @type {?Object} */
  let currentParent = null;

  /**
   * Gets the current Element being patched.
   * @return {!Element}
   */
  const currentElement = function () {
    return currentParent;
  };

  /**
   * @return {Node} The Node that will be evaluated for the next instruction.
   */
  const currentPointer = function () {
    return {};
  };

  /**
   * Patches an Element with the the provided function. Exactly one top level
   * element call should be made corresponding to `node`.
   *
   * @param {?object} node The Element where the patch should start.
   * @param {!function(T)} fn A function containing open/close/etc. calls that
   *     describe the DOM. This should have at most one top level element call.
   * @param {T=} data An argument passed to fn to represent DOM state.
   * @return {void} Nothing.
   */
  const patch = function (node, fn, data) {
    currentParent = node;
    fn(data);
    currentParent.innerHTML = buffer.join('');
    buffer = [];
    return currentParent;
  };

  const patchOuter = patch;
  const patchInner = patch;

  /**
   * Declares a virtual Text at this point in the document.
   *
   * @param {string|number|boolean} value The value of the Text.
   * @param {...(function((string|number|boolean)):string)} var_args
   *     Functions to format the value which are called only when the value has
   *     changed.
   *
   * @return {void} Nothing.
   */
  const text = function (value, var_args) {
    let formatted = value;
    for (let i = 1; i < arguments.length; i += 1) {
      const fn = arguments[i];
      formatted = fn(formatted);
    }
    buffer.push(formatted);
  };

  export { buffer, currentElement, currentParent, currentPointer, patch, patchInner, patchOuter, text };
});
//# sourceMappingURL=core.js.map