/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorModule;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackagesTracker;
import com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModule;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModuleNameMapper;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolution;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter.JSBrowserModule;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter.JSConfigGeneratorBrowserModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.util.Portal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, service={BrowserModulesResolver.class})
public class BrowserModulesResolver {
    @Reference
    private BrowserModuleNameMapper _browserModuleNameMapper;
    private Details _details;
    @Reference
    private JSConfigGeneratorPackagesTracker _jsConfigGeneratorPackagesTracker;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMRegistry _npmRegistry;
    @Reference
    private Portal _portal;

    public BrowserModulesResolution resolve(List<String> moduleNames) {
        BrowserModulesResolution browserModulesResolution = new BrowserModulesResolution(this._jsonFactory, this._details.explainResolutions());
        Map<String, BrowserModule> browserModulesMap = this._getBrowserModulesMap();
        for (String moduleName : moduleNames) {
            this._resolve(browserModulesMap, moduleName, browserModulesResolution);
        }
        this._populateMappedModuleNames(browserModulesResolution);
        return browserModulesResolution;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
    }

    private Map<String, BrowserModule> _getBrowserModulesMap() {
        HashMap<String, BrowserModule> browserModulesMap = new HashMap<String, BrowserModule>();
        for (JSConfigGeneratorPackage jsConfigGeneratorPackage : this._jsConfigGeneratorPackagesTracker.getJSConfigGeneratorPackages()) {
            for (JSConfigGeneratorModule jsConfigGeneratorModule : jsConfigGeneratorPackage.getJSConfigGeneratorModules()) {
                JSConfigGeneratorBrowserModule jsConfigGeneratorBrowserModule = new JSConfigGeneratorBrowserModule(jsConfigGeneratorModule);
                browserModulesMap.put(jsConfigGeneratorBrowserModule.getName(), jsConfigGeneratorBrowserModule);
            }
        }
        for (JSModule jsModule : this._npmRegistry.getResolvedJSModules()) {
            JSBrowserModule jsBrowserModule = new JSBrowserModule(jsModule, this._npmRegistry);
            browserModulesMap.put(jsBrowserModule.getName(), jsBrowserModule);
        }
        return browserModulesMap;
    }

    private void _populateMappedModuleNames(BrowserModulesResolution browserModulesResolution) {
        HashSet<JSPackage> jsPackages = new HashSet<JSPackage>();
        for (String moduleName : browserModulesResolution.getResolvedModuleNames()) {
            String packageName = ModuleNameUtil.getPackageName((String)moduleName);
            JSPackage jsPackage = this._npmRegistry.getResolvedJSPackage(packageName);
            if (jsPackage == null) continue;
            jsPackages.add(jsPackage);
        }
        for (JSPackage jsPackage : jsPackages) {
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                browserModulesResolution.putMappedModuleName(jsPackage.getResolvedId() + "/" + jsModuleAlias.getAlias(), jsPackage.getResolvedId() + "/" + jsModuleAlias.getModuleName(), true);
            }
        }
    }

    private boolean _processBrowserModule(Map<String, BrowserModule> browserModulesMap, BrowserModule browserModule, BrowserModulesResolution browserModulesResolution) {
        String moduleName = browserModule.getName();
        if (browserModulesResolution.isProcessedModuleName(moduleName)) {
            return false;
        }
        browserModulesResolution.addProcessedModuleName(moduleName);
        HashMap<String, String> dependenciesMap = new HashMap<String, String>();
        browserModulesResolution.indentExplanation();
        for (String dependency : browserModule.getDependencies()) {
            if (ModuleNameUtil.isReservedModuleName((String)dependency)) continue;
            String dependencyModuleName = ModuleNameUtil.getDependencyPath((String)moduleName, (String)dependency);
            dependencyModuleName = this._browserModuleNameMapper.mapModuleName(dependencyModuleName, browserModule.getDependenciesMap());
            dependenciesMap.put(dependency, dependencyModuleName);
            BrowserModule dependencyBrowserModule = browserModulesMap.get(dependencyModuleName);
            if (dependencyBrowserModule != null) {
                this._processBrowserModule(browserModulesMap, dependencyBrowserModule, browserModulesResolution);
                continue;
            }
            browserModulesResolution.addResolvedModuleName(StringBundler.concat((String[])new String[]{":ERROR:Missing dependency '", dependencyModuleName, "' of '", moduleName, "'"}));
        }
        browserModulesResolution.dedentExplanation();
        browserModulesResolution.putDependenciesMap(moduleName, dependenciesMap);
        browserModulesResolution.putPath(moduleName, browserModule.getPath());
        browserModulesResolution.addResolvedModuleName(moduleName);
        return true;
    }

    private void _resolve(Map<String, BrowserModule> browserModulesMap, String moduleName, BrowserModulesResolution browserModulesResolution) {
        String mappedModuleName = this._browserModuleNameMapper.mapModuleName(moduleName);
        BrowserModule browserModule = browserModulesMap.get(mappedModuleName);
        if (browserModule == null) {
            browserModulesResolution.addResolvedModuleName(":ERROR:Missing required module '" + moduleName + "'");
            return;
        }
        if (!moduleName.equals(mappedModuleName)) {
            browserModulesResolution.putMappedModuleName(moduleName, mappedModuleName, true);
        }
        this._processBrowserModule(browserModulesMap, browserModule, browserModulesResolution);
    }
}

