/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackagesTracker;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModuleNameMapperCache;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BrowserModuleNameMapper.class})
public class BrowserModuleNameMapper {
    private final AtomicReference<BrowserModuleNameMapperCache> _browserModuleNameMapperCache = new AtomicReference();
    private JSBundleTracker _jsBundleTracker = new JSBundleTracker(){

        public void addedJSBundle(JSBundle jsBundle, Bundle bundle, NPMRegistry npmRegistry) {
            BrowserModuleNameMapper.this._clearCache();
        }

        public void removedJSBundle(JSBundle jsBundle, Bundle bundle, NPMRegistry npmRegistry) {
            BrowserModuleNameMapper.this._clearCache();
        }
    };
    @Reference
    private JSConfigGeneratorPackagesTracker _jsConfigGeneratorPackagesTracker;
    @Reference
    private NPMRegistry _npmRegistry;

    public String mapModuleName(String moduleName) {
        return this.mapModuleName(moduleName, null);
    }

    public String mapModuleName(String moduleName, Map<String, String> dependenciesMap) {
        String mappedModuleName;
        BrowserModuleNameMapperCache browserModuleNameMapperCache = this._browserModuleNameMapperCache.get();
        if (browserModuleNameMapperCache.isOlderThan(this._jsConfigGeneratorPackagesTracker.getLastModified())) {
            this._clearCache();
            browserModuleNameMapperCache = this._browserModuleNameMapperCache.get();
        }
        if ((mappedModuleName = browserModuleNameMapperCache.get(moduleName, dependenciesMap)) != null) {
            return mappedModuleName;
        }
        mappedModuleName = moduleName;
        if (dependenciesMap != null) {
            mappedModuleName = this._map(moduleName, dependenciesMap, dependenciesMap);
        }
        mappedModuleName = this._map(mappedModuleName, browserModuleNameMapperCache.getExactMatchMap(), browserModuleNameMapperCache.getPartialMatchMap());
        browserModuleNameMapperCache.put(moduleName, dependenciesMap, mappedModuleName);
        return mappedModuleName;
    }

    @Activate
    protected void activate() {
        this._npmRegistry.addJSBundleTracker(this._jsBundleTracker);
    }

    @Deactivate
    protected void deactivate() {
        this._npmRegistry.removeJSBundleTracker(this._jsBundleTracker);
    }

    private void _clearCache() {
        this._browserModuleNameMapperCache.set(new BrowserModuleNameMapperCache(this._getExactMatchMap(), this._getPartialMatchMap()));
    }

    private Map<String, String> _getExactMatchMap() {
        HashMap<String, String> exactMatchMap = new HashMap<String, String>();
        for (JSPackage jsPackage : this._npmRegistry.getResolvedJSPackages()) {
            String mainModuleResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsPackage.getMainModuleName());
            exactMatchMap.put(jsPackage.getResolvedId(), mainModuleResolvedId);
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                String aliasResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getAlias());
                String moduleResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getModuleName());
                exactMatchMap.put(aliasResolvedId, moduleResolvedId);
            }
        }
        return exactMatchMap;
    }

    private Map<String, String> _getPartialMatchMap() {
        HashMap<String, String> partialMatchMap = new HashMap<String, String>();
        Collection<JSConfigGeneratorPackage> jsConfigGeneratorPackages = this._jsConfigGeneratorPackagesTracker.getJSConfigGeneratorPackages();
        for (JSConfigGeneratorPackage jsConfigGeneratorPackage : jsConfigGeneratorPackages) {
            String jsConfigGeneratorPackageResolvedId = jsConfigGeneratorPackage.getName() + "@" + jsConfigGeneratorPackage.getVersion();
            partialMatchMap.put(jsConfigGeneratorPackage.getName(), jsConfigGeneratorPackageResolvedId);
        }
        partialMatchMap.putAll(this._npmRegistry.getGlobalAliases());
        return partialMatchMap;
    }

    private String _map(String moduleName, Map<String, String> exactMatchMap, Map<String, String> partialMatchMap) {
        String mappedModuleName = exactMatchMap.get(moduleName);
        if (Validator.isNotNull((String)mappedModuleName)) {
            return mappedModuleName;
        }
        for (Map.Entry<String, String> entry : partialMatchMap.entrySet()) {
            String resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return entry.getValue() + moduleName.substring(resolvedId.length());
        }
        return moduleName;
    }
}

