/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.config.generator;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorModule;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class JSConfigGeneratorPackage {
    private static final Log _log = LogFactoryUtil.getLog(JSConfigGeneratorPackage.class);
    private final boolean _applyVersioning;
    private final Bundle _bundle;
    private final String _contextPath;
    private List<JSConfigGeneratorModule> _jsConfigGeneratorModules = new ArrayList<JSConfigGeneratorModule>();
    private final String _name;
    private String _unversionedConfiguration = "";
    private String _unversionedMapsConfiguration = "";
    private final String _version;
    private String _versionedConfiguration = "";

    public JSConfigGeneratorPackage(boolean applyVersioning, Bundle bundle, String contextPath) {
        this._applyVersioning = applyVersioning;
        this._bundle = bundle;
        this._contextPath = contextPath;
        Version version = this._bundle.getVersion();
        this._version = version.toString();
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        List bundleCapabilities = bundleWiring.getCapabilities("osgi.webresource");
        if (bundleCapabilities.isEmpty()) {
            this._name = this._bundle.getSymbolicName();
            return;
        }
        BundleCapability bundleCapability = (BundleCapability)bundleCapabilities.get(0);
        Map attributes = bundleCapability.getAttributes();
        this._name = (String)attributes.get("osgi.webresource");
        URL url = this._bundle.getEntry("META-INF/config.json");
        this.urlToConfiguration(url, bundleWiring);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public List<JSConfigGeneratorModule> getJSConfigGeneratorModules() {
        return this._jsConfigGeneratorModules;
    }

    public String getName() {
        return this._name;
    }

    public String getUnversionedConfiguration() {
        return this._unversionedConfiguration;
    }

    public String getUnversionedMapsConfiguration() {
        return this._unversionedMapsConfiguration;
    }

    public String getVersion() {
        return this._version;
    }

    public String getVersionedConfiguration() {
        return this._versionedConfiguration;
    }

    protected JSONObject generateConfigurationJSONObject(JSONObject jsonObject, BundleWiring bundleWiring, boolean versionedModuleName) {
        if (!this._applyVersioning) {
            if (versionedModuleName) {
                return new JSONObject();
            }
            return jsonObject;
        }
        JSONArray namesJSONArray = jsonObject.names();
        if (namesJSONArray == null) {
            return jsonObject;
        }
        List bundleWires = bundleWiring.getRequiredWires("osgi.webresource");
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            String moduleName;
            String name = (String)namesJSONArray.get(i);
            int index = name.indexOf("/");
            if (index == -1 || !(moduleName = name.substring(0, index)).equals(this.getName())) continue;
            String modulePath = name.substring(index);
            moduleName = StringBundler.concat((String[])new String[]{this.getName(), "@", this.getVersion(), modulePath});
            JSONObject nameJSONObject = jsonObject.getJSONObject(name);
            JSONArray dependenciesJSONArray = nameJSONObject.getJSONArray("dependencies");
            for (int j = 0; j < dependenciesJSONArray.length(); ++j) {
                String dependency = dependenciesJSONArray.getString(j);
                index = dependency.indexOf(47);
                if (index == -1) continue;
                String dependencyName = dependency.substring(0, index);
                String dependencyPath = dependency.substring(index);
                if (dependencyName.equals(this.getName())) {
                    dependencyName = StringBundler.concat((String[])new String[]{this.getName(), "@", this.getVersion(), dependencyPath});
                    dependenciesJSONArray.put(j, (Object)dependencyName);
                    continue;
                }
                this.normalizeDependencies(dependencyName, dependencyPath, dependenciesJSONArray, j, bundleWires);
            }
            if (versionedModuleName) {
                jsonObject.remove(name);
                jsonObject.put(moduleName, (Object)nameJSONObject);
                continue;
            }
            jsonObject.put(name, (Object)nameJSONObject);
        }
        return jsonObject;
    }

    protected JSONObject generateMapsConfigurationJSONObject(String configuration, String[] jsSubmodulesExport) {
        boolean exportAll = ArrayUtil.contains((Object[])jsSubmodulesExport, (Object)"*");
        JSONObject mapsConfigurationJSONObject = new JSONObject();
        JSONObject configurationJSONObject = new JSONObject("{" + configuration + "}");
        JSONArray namesJSONArray = configurationJSONObject.names();
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            String name = (String)namesJSONArray.get(i);
            int x = name.indexOf("/");
            String moduleRootPath = name.substring(0, x + 1);
            String submodulePath = name.substring(x + 1);
            int index = submodulePath.indexOf("/");
            if (index == -1) continue;
            String submoduleName = submodulePath.substring(0, index);
            if (!exportAll && !ArrayUtil.exists((Object[])jsSubmodulesExport, item -> this._matchesWildcard(submoduleName, (String)item))) continue;
            mapsConfigurationJSONObject.put(submoduleName, (Object)moduleRootPath.concat(submoduleName));
        }
        return mapsConfigurationJSONObject;
    }

    protected void normalizeDependencies(String dependencyName, String dependencyPath, JSONArray jsonArray, int index, List<BundleWire> bundleWires) {
        for (BundleWire bundleWire : bundleWires) {
            BundleCapability bundleCapability = bundleWire.getCapability();
            Map attributes = bundleCapability.getAttributes();
            String attributesDependencyName = (String)attributes.get("osgi.webresource");
            if (!attributesDependencyName.equals(dependencyName)) continue;
            Version version = (Version)attributes.get("version");
            dependencyName = StringBundler.concat((String[])new String[]{dependencyName, "@", version.toString(), dependencyPath});
            jsonArray.put(index, (Object)dependencyName);
            return;
        }
    }

    protected String removeEnclosingCurlyBraces(JSONObject jsonObject) {
        String json = jsonObject.toString();
        json = json.substring(1, json.length() - 1);
        return json;
    }

    protected void urlToConfiguration(URL url, BundleWiring bundleWiring) {
        if (url == null) {
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            JSONTokener jsonTokener = new JSONTokener((Reader)reader);
            JSONObject jsonObject = new JSONObject(jsonTokener);
            JSONObject unversionedConfigurationJSONObject = this.generateConfigurationJSONObject(jsonObject, bundleWiring, false);
            this._unversionedConfiguration = this.removeEnclosingCurlyBraces(unversionedConfigurationJSONObject);
            this._versionedConfiguration = this.removeEnclosingCurlyBraces(this.generateConfigurationJSONObject(jsonObject, bundleWiring, true));
            Dictionary headers = this._bundle.getHeaders("");
            String jsSubmodulesExport = GetterUtil.getString((String)((String)headers.get("Liferay-JS-Submodules-Export")));
            if (Validator.isNotNull((String)jsSubmodulesExport)) {
                this._unversionedMapsConfiguration = this.removeEnclosingCurlyBraces(this.generateMapsConfigurationJSONObject(this._unversionedConfiguration, StringUtil.split((String)jsSubmodulesExport)));
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Liferay-JS-Submodules-Export is deprecated and replaced with Liferay-JS-Submodules-Bridge");
                }
            }
            this._populateJSConfigGeneratorModules(unversionedConfigurationJSONObject);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean _matchesWildcard(String text, String pattern) {
        pattern = StringUtil.replace((String)pattern, (String[])new String[]{"?", "*"}, (String[])new String[]{".?", ".*"});
        return text.matches(pattern);
    }

    private void _populateJSConfigGeneratorModules(JSONObject unversionedConfigurationJSONObject) {
        for (Object key : unversionedConfigurationJSONObject.keySet()) {
            String moduleId = (String)key;
            ArrayList<String> dependencies = new ArrayList<String>();
            JSONObject moduleJSONObject = unversionedConfigurationJSONObject.getJSONObject(moduleId);
            JSONArray dependenciesJSONArray = moduleJSONObject.getJSONArray("dependencies");
            for (int i = 0; i < dependenciesJSONArray.length(); ++i) {
                dependencies.add((String)dependenciesJSONArray.get(i));
            }
            this._jsConfigGeneratorModules.add(new JSConfigGeneratorModule(this, moduleId, dependencies, this._contextPath));
        }
    }
}

