/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolverUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class NPMResolvedPackageNameUtil {
    private static final Object _NULL_HOLDER = new Object();
    private static final Log _log = LogFactoryUtil.getLog(NPMResolvedPackageNameUtil.class);

    public static String get(HttpServletRequest httpServletRequest) {
        PortletBag portletBag;
        ServletContext servletContext = httpServletRequest.getServletContext();
        String portletResource = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource) && (portletBag = PortletBagPool.get((String)PortletIdCodec.decodePortletName((String)portletResource))) != null) {
            servletContext = portletBag.getServletContext();
        }
        return NPMResolvedPackageNameUtil.get(servletContext);
    }

    public static String get(ServletContext servletContext) {
        Object object = servletContext.getAttribute(NPMResolvedPackageNameUtil.class.getName());
        if (object instanceof String) {
            return (String)object;
        }
        if (object == _NULL_HOLDER) {
            return null;
        }
        String npmResolvedPackageName = NPMResolvedPackageNameUtil._getNPMResolvedPackageName(ServletContextClassLoaderPool.getClassLoader((String)servletContext.getServletContextName()));
        if (npmResolvedPackageName == null) {
            servletContext.setAttribute(NPMResolvedPackageNameUtil.class.getName(), _NULL_HOLDER);
        } else {
            servletContext.setAttribute(NPMResolvedPackageNameUtil.class.getName(), (Object)npmResolvedPackageName);
        }
        return npmResolvedPackageName;
    }

    public static void set(ServletContext servletContext, String npmResolvedPackageName) {
        if (npmResolvedPackageName != null) {
            servletContext.setAttribute(NPMResolvedPackageNameUtil.class.getName(), (Object)npmResolvedPackageName);
        } else {
            servletContext.removeAttribute(NPMResolvedPackageNameUtil.class.getName());
        }
    }

    private static String _getNPMResolvedPackageName(Bundle bundle, NPMResolver npmResolver) {
        URL url = bundle.getResource("META-INF/resources/package.json");
        if (url == null) {
            return null;
        }
        try {
            String json = StringUtil.read((InputStream)url.openStream());
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
            String name = jsonObject.getString("name");
            return npmResolver.resolveModuleName(name);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to resolve NPM package " + bundle.getSymbolicName()), (Throwable)exception);
            return null;
        }
    }

    private static String _getNPMResolvedPackageName(ClassLoader classLoader) {
        if (!(classLoader instanceof BundleReference)) {
            return null;
        }
        BundleReference bundleReference = (BundleReference)classLoader;
        Bundle bundle = bundleReference.getBundle();
        return NPMResolvedPackageNameUtil._getNPMResolvedPackageName(bundle, NPMResolverUtil.getNPMResolver(bundle));
    }
}

