/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class NPMResolverUtil {
    private static final Map<Bundle, NPMResolver> _npmResolverMap = new ConcurrentHashMap<Bundle, NPMResolver>();

    public static JSPackage getDependencyJSPackage(Bundle bundle, String packageName) {
        NPMResolver npmResolver = NPMResolverUtil._getNPMResolver(bundle);
        return npmResolver.getDependencyJSPackage(packageName);
    }

    public static JSPackage getDependencyJSPackage(Class<?> clazz, String packageName) {
        return NPMResolverUtil.getDependencyJSPackage(FrameworkUtil.getBundle(clazz), packageName);
    }

    public static NPMResolver getNPMResolver(Bundle bundle) {
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(NPMResolver.class);
        if (serviceReference == null) {
            throw new IllegalArgumentException("Bundle " + bundle.getSymbolicName() + " does not have an associated NPMResolver");
        }
        NPMResolver npmResolver = (NPMResolver)bundleContext.getService(serviceReference);
        if (npmResolver == null) {
            throw new IllegalArgumentException("Bundle " + bundle.getSymbolicName() + " does not have an associated NPMResolver");
        }
        return npmResolver;
    }

    public static String resolveModuleName(Bundle bundle, String moduleName) {
        NPMResolver npmResolver = NPMResolverUtil._getNPMResolver(bundle);
        return npmResolver.resolveModuleName(moduleName);
    }

    public static String resolveModuleName(Class<?> clazz, String moduleName) {
        return NPMResolverUtil.resolveModuleName(FrameworkUtil.getBundle(clazz), moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Bundle bundle, NPMResolver npmResolver) {
        Map<Bundle, NPMResolver> map = _npmResolverMap;
        synchronized (map) {
            if (npmResolver == null) {
                _npmResolverMap.remove(bundle);
            } else {
                _npmResolverMap.put(bundle, npmResolver);
            }
        }
    }

    public JSPackage getJSPackage(Bundle bundle) {
        NPMResolver npmResolver = NPMResolverUtil._getNPMResolver(bundle);
        return npmResolver.getJSPackage();
    }

    public JSPackage getJSPackage(Class<?> clazz) {
        return this.getJSPackage(FrameworkUtil.getBundle(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NPMResolver _getNPMResolver(Bundle bundle) {
        NPMResolver npmResolver;
        Map<Bundle, NPMResolver> map = _npmResolverMap;
        synchronized (map) {
            npmResolver = _npmResolverMap.get(bundle);
        }
        if (npmResolver == null) {
            throw new IllegalArgumentException("Bundle " + bundle.getSymbolicName() + " does not have an associated NPMResolver");
        }
        return npmResolver;
    }
}

