Liferay.Loader.define("frontend-js-jquery-web$jquery@3.5.1/src/css/support", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	define(["../core", "../var/document", "../var/documentElement", "../var/support"], function (jQuery, document, documentElement, support) {

		"use strict";

		(function () {

			// Executing both pixelPosition & boxSizingReliable tests require only one layout
			// so they're executed at the same time to save the second computation.
			function computeStyleTests() {

				// This is a singleton, we need to execute it only once
				if (!div) {
					return;
				}

				container.style.cssText = "position:absolute;left:-11111px;width:60px;" + "margin-top:1px;padding:0;border:0";
				div.style.cssText = "position:relative;display:block;box-sizing:border-box;overflow:scroll;" + "margin:auto;border:1px;padding:1px;" + "width:60%;top:1%";
				documentElement.appendChild(container).appendChild(div);

				var divStyle = window.getComputedStyle(div);
				pixelPositionVal = divStyle.top !== "1%";

				// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
				reliableMarginLeftVal = roundPixelMeasures(divStyle.marginLeft) === 12;

				// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
				// Some styles come back with percentage values, even though they shouldn't
				div.style.right = "60%";
				pixelBoxStylesVal = roundPixelMeasures(divStyle.right) === 36;

				// Support: IE 9 - 11 only
				// Detect misreporting of content dimensions for box-sizing:border-box elements
				boxSizingReliableVal = roundPixelMeasures(divStyle.width) === 36;

				// Support: IE 9 only
				// Detect overflow:scroll screwiness (gh-3699)
				// Support: Chrome <=64
				// Don't get tricked when zoom affects offsetWidth (gh-4029)
				div.style.position = "absolute";
				scrollboxSizeVal = roundPixelMeasures(div.offsetWidth / 3) === 12;

				documentElement.removeChild(container);

				// Nullify the div so it wouldn't be stored in the memory and
				// it will also be a sign that checks already performed
				div = null;
			}

			function roundPixelMeasures(measure) {
				return Math.round(parseFloat(measure));
			}

			var pixelPositionVal,
			    boxSizingReliableVal,
			    scrollboxSizeVal,
			    pixelBoxStylesVal,
			    reliableTrDimensionsVal,
			    reliableMarginLeftVal,
			    container = document.createElement("div"),
			    div = document.createElement("div");

			// Finish early in limited (non-browser) environments
			if (!div.style) {
				return;
			}

			// Support: IE <=9 - 11 only
			// Style of cloned element affects source element cloned (#8908)
			div.style.backgroundClip = "content-box";
			div.cloneNode(true).style.backgroundClip = "";
			support.clearCloneStyle = div.style.backgroundClip === "content-box";

			jQuery.extend(support, {
				boxSizingReliable: function () {
					computeStyleTests();
					return boxSizingReliableVal;
				},
				pixelBoxStyles: function () {
					computeStyleTests();
					return pixelBoxStylesVal;
				},
				pixelPosition: function () {
					computeStyleTests();
					return pixelPositionVal;
				},
				reliableMarginLeft: function () {
					computeStyleTests();
					return reliableMarginLeftVal;
				},
				scrollboxSize: function () {
					computeStyleTests();
					return scrollboxSizeVal;
				},

				// Support: IE 9 - 11+, Edge 15 - 18+
				// IE/Edge misreport `getComputedStyle` of table rows with width/height
				// set in CSS while `offset*` properties report correct values.
				// Behavior in IE 9 is more subtle than in newer versions & it passes
				// some versions of this test; make sure not to make it pass there!
				reliableTrDimensions: function () {
					var table, tr, trChild, trStyle;
					if (reliableTrDimensionsVal == null) {
						table = document.createElement("table");
						tr = document.createElement("tr");
						trChild = document.createElement("div");

						table.style.cssText = "position:absolute;left:-11111px";
						tr.style.height = "1px";
						trChild.style.height = "9px";

						documentElement.appendChild(table).appendChild(tr).appendChild(trChild);

						trStyle = window.getComputedStyle(tr);
						reliableTrDimensionsVal = parseInt(trStyle.height) > 3;

						documentElement.removeChild(table);
					}
					return reliableTrDimensionsVal;
				}
			});
		})();

		return support;
	});
});
//# sourceMappingURL=support.js.map