Liferay.Loader.define("frontend-js-dropdown-support-web@1.0.8/DropdownProvider", ['module', 'exports', 'require', 'frontend-js-dropdown-support-web$dom-align', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _domAlign = _interopRequireDefault(require("frontend-js-dropdown-support-web$dom-align"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var CssClass = {
    SHOW: 'show'
  };
  var Selector = {
    TRIGGER: '[data-toggle="liferay-dropdown"]'
  };
  var KEYCODES = {
    ENTER: 13,
    SPACE: 32
  };

  var DropdownProvider = /*#__PURE__*/function () {
    function DropdownProvider() {
      var _this = this;

      _classCallCheck(this, DropdownProvider);

      _defineProperty(this, "EVENT_HIDDEN", 'liferay.dropdown.hidden');

      _defineProperty(this, "EVENT_HIDE", 'liferay.dropdown.hide');

      _defineProperty(this, "EVENT_SHOW", 'liferay.dropdown.show');

      _defineProperty(this, "EVENT_SHOWN", 'liferay.dropdown.shown');

      _defineProperty(this, "hide", function (_ref) {
        var menu = _ref.menu,
            trigger = _ref.trigger;

        if (menu && !trigger) {
          trigger = _this._getTrigger(menu);
        }

        if (!menu) {
          menu = _this._getMenu(trigger);
        }

        if (!menu.classList.contains(CssClass.SHOW)) {
          return;
        }

        Liferay.fire(_this.EVENT_HIDE, {
          menu: menu,
          trigger: trigger
        });
        trigger.parentElement.classList.remove(CssClass.SHOW);
        trigger.setAttribute('aria-expanded', false);
        menu.classList.remove(CssClass.SHOW);
        Liferay.fire(_this.EVENT_HIDDEN, {
          menu: menu,
          trigger: trigger
        });
      });

      _defineProperty(this, "show", function (_ref2) {
        var menu = _ref2.menu,
            trigger = _ref2.trigger;

        if (menu && !trigger) {
          trigger = _this._getTrigger(menu);
        }

        if (!menu) {
          menu = _this._getMenu(trigger);
        }

        if (menu.classList.contains(CssClass.SHOW)) {
          return;
        }

        Liferay.fire(_this.EVENT_SHOW, {
          menu: menu,
          trigger: trigger
        });
        trigger.parentElement.classList.add(CssClass.SHOW);
        trigger.setAttribute('aria-expanded', true);

        var clickOutsideHandler = function clickOutsideHandler(event) {
          if (!menu.contains(event.target) && !trigger.contains(event.target)) {
            _this.hide({
              menu: menu,
              trigger: trigger
            });

            document.removeEventListener('mousedown', clickOutsideHandler);
            document.removeEventListener('touchstart', clickOutsideHandler);
          }
        };

        document.addEventListener('mousedown', clickOutsideHandler);
        document.addEventListener('touchstart', clickOutsideHandler);
        menu.classList.add(CssClass.SHOW);
        (0, _domAlign["default"])(menu, trigger, {
          overflow: {
            adjustX: true,
            adjustY: true
          },
          points: ['tl', 'bl']
        });
        Liferay.fire(_this.EVENT_SHOWN, {
          menu: menu,
          trigger: trigger
        });
      });

      _defineProperty(this, "_onKeyDown", function (event) {
        if (event.keyCode === KEYCODES.ENTER || event.keyCode === KEYCODES.SPACE) {
          _this._onTriggerClick(event);
        }
      });

      _defineProperty(this, "_onTriggerClick", function (event) {
        var trigger = event.delegateTarget;

        if (trigger.tagName === 'A') {
          event.preventDefault();
        }

        var menu = _this._getMenu(trigger);

        if (menu) {
          if (menu.classList.contains(CssClass.SHOW)) {
            _this.hide({
              menu: menu,
              trigger: trigger
            });
          } else {
            _this.show({
              menu: menu,
              trigger: trigger
            });
          }
        }
      });

      if (Liferay.DropdownProvider) {
        return Liferay.DropdownProvider;
      }

      _metalDom["default"].delegate(document.body, 'click', Selector.TRIGGER, this._onTriggerClick);

      _metalDom["default"].delegate(document.body, 'keydown', Selector.TRIGGER, this._onKeyDown);

      Liferay.DropdownProvider = this;
    }

    _createClass(DropdownProvider, [{
      key: "_getMenu",
      value: function _getMenu(trigger) {
        return trigger.parentElement.querySelector('.dropdown-menu');
      }
    }, {
      key: "_getTrigger",
      value: function _getTrigger(menu) {
        return menu.parentElement.querySelector('.dropdown-toggle');
      }
    }]);

    return DropdownProvider;
  }();

  var _default = DropdownProvider;
  exports["default"] = _default;
  //# sourceMappingURL=DropdownProvider.js.map
});
//# sourceMappingURL=DropdownProvider.js.map