/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.bundle.config.extender.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={JSBundleConfigRegistry.class})
public class JSBundleConfigRegistry
implements ServiceTrackerCustomizer<ServletContext, ServiceReference<ServletContext>> {
    private BundleContext _bundleContext;
    private final Map<ServiceReference<ServletContext>, JSConfig> _jsConfigs = new ConcurrentSkipListMap<ServiceReference<ServletContext>, JSConfig>();
    private volatile long _lastModified = System.currentTimeMillis();
    private ServiceTracker<ServletContext, ServiceReference<ServletContext>> _serviceTracker;

    public ServiceReference<ServletContext> addingService(ServiceReference<ServletContext> serviceReference) {
        URL url;
        Bundle bundle = serviceReference.getBundle();
        Dictionary headers = bundle.getHeaders("");
        String jsConfig = (String)headers.get("Liferay-JS-Config");
        if (jsConfig != null && (url = bundle.getEntry(jsConfig)) != null) {
            ServletContext servletContext = (ServletContext)this._bundleContext.getService(serviceReference);
            this._jsConfigs.put(serviceReference, new JSConfig(servletContext, url));
            this._lastModified = System.currentTimeMillis();
            return serviceReference;
        }
        return null;
    }

    public Collection<JSConfig> getJSConfigs() {
        return this._jsConfigs.values();
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public long getTrackingCount() {
        return this._serviceTracker.getTrackingCount();
    }

    public void modifiedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        this.removedService(serviceReference, trackedServiceReference);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        JSConfig jsConfig = this._jsConfigs.remove(serviceReference);
        if (jsConfig != null) {
            this._bundleContext.ungetService(serviceReference);
            this._lastModified = System.currentTimeMillis();
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
        this._bundleContext = componentContext.getBundleContext();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)this);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._serviceTracker = null;
    }

    public static class JSConfig {
        private final ServletContext _servletContext;
        private final URL _url;

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        public URL getURL() {
            return this._url;
        }

        private JSConfig(ServletContext servletContext, URL url) {
            this._servletContext = servletContext;
            this._url = url;
        }
    }
}

