/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.bundle.config.extender.internal.servlet.taglib;

import com.liferay.frontend.js.bundle.config.extender.internal.JSBundleConfigTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.BaseDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={DynamicInclude.class})
public class JSBundleConfigTopHeadDynamicInclude
extends BaseDynamicInclude {
    private static final Log _log = LogFactoryUtil.getLog(JSBundleConfigTopHeadDynamicInclude.class);
    private JSBundleConfigTracker _jsBundleConfigTracker;
    @Reference
    private JSONFactory _jsonFactory;
    private volatile ObjectValuePair<Long, String> _objectValuePair = new ObjectValuePair((Object)0L, null);
    @Reference
    private Portal _portal;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        if (!this._isStale()) {
            this._writeResponse(httpServletResponse, (String)this._objectValuePair.getValue());
            return;
        }
        StringWriter stringWriter = new StringWriter();
        Collection<JSBundleConfigTracker.JSConfig> jsConfigs = this._jsBundleConfigTracker.getJSConfigs();
        if (!jsConfigs.isEmpty()) {
            stringWriter.write("<script data-senna-track=\"temporary\" ");
            stringWriter.write("type=\"");
            stringWriter.write("text/javascript");
            stringWriter.write("\">");
            for (JSBundleConfigTracker.JSConfig jsConfig : jsConfigs) {
                URL url = jsConfig.getURL();
                try {
                    InputStream inputStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        stringWriter.write("try {");
                        ServletContext servletContext = jsConfig.getServletContext();
                        stringWriter.write(StringBundler.concat((String[])new String[]{"var MODULE_MAIN='", this._getModuleMain(jsConfig), "';"}));
                        stringWriter.write(StringBundler.concat((String[])new String[]{"var MODULE_PATH='", this._portal.getPathProxy(), servletContext.getContextPath(), "';"}));
                        stringWriter.write(StringUtil.removeSubstring((String)StringUtil.read((InputStream)inputStream), (String)"//# sourceMappingURL=config.js.map"));
                        stringWriter.write("} catch(error) {console.error(error);}");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)"Unable to open resource", (Throwable)exception);
                }
            }
            stringWriter.write("</script>");
        }
        String bundleConfig = stringWriter.toString();
        this._objectValuePair = new ObjectValuePair((Object)this._jsBundleConfigTracker.getLastModified(), (Object)bundleConfig);
        this._writeResponse(httpServletResponse, bundleConfig);
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_js.jspf#resources");
    }

    @Reference(unbind="-")
    protected void setJSBundleConfigTracker(JSBundleConfigTracker jsBundleConfigTracker) {
        this._jsBundleConfigTracker = jsBundleConfigTracker;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getModuleMain(JSBundleConfigTracker.JSConfig jsConfig) {
        try {
            ServletContext servletContext = jsConfig.getServletContext();
            URL url = servletContext.getResource("META-INF/resources/package.json");
            if (url == null) {
                url = servletContext.getResource("package.json");
            }
            if (url == null) {
                return null;
            }
            try (InputStream inputStream = url.openStream();){
                JSONObject jsonObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)inputStream));
                String moduleName = jsonObject.getString("name");
                String moduleVersion = jsonObject.getString("version");
                String moduleMain = jsonObject.getString("main");
                if (Validator.isNull((String)moduleMain)) {
                    moduleMain = "index.js";
                }
                String string = StringBundler.concat((String[])new String[]{moduleName, "@", moduleVersion, "/", ModuleNameUtil.toModuleName((String)moduleMain)});
                return string;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean _isStale() {
        return this._jsBundleConfigTracker.getLastModified() > (Long)this._objectValuePair.getKey();
    }

    private void _writeResponse(HttpServletResponse httpServletResponse, String content) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(content);
    }
}

