/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

/**
 * The Store Utility
 *
 * @deprecated As of Athanasius (7.3.x), replaced by Liferay.Util.Session
 * @module liferay-store
 */

AUI.add(
	'liferay-store',
	(A) => {
		const Lang = A.Lang;

		const isObject = Lang.isObject;

		const TOKEN_SERIALIZE = 'serialize://';

		const Store = function (key, value) {
			let method;

			if (Lang.isFunction(value)) {
				method = 'get';

				if (Array.isArray(key)) {
					method = 'getAll';
				}
			}
			else {
				method = 'set';

				if (isObject(key)) {
					method = 'setAll';
				}
				else if (arguments.length === 1) {
					method = null;
				}
			}

			if (method) {
				Store[method].apply(Store, arguments);
			}
		};

		A.mix(Store, {
			_getValues(cmd, key, callback) {
				const instance = this;

				const config = {
					callback,
					data: {
						cmd,
						key,
					},
				};

				if (cmd === 'getAll') {
					config.dataType = 'json';
				}

				instance._ioRequest(config);
			},

			_ioRequest(config) {
				config.data.p_auth = Liferay.authToken;

				const doAsUserIdEncoded = themeDisplay.getDoAsUserIdEncoded();

				if (doAsUserIdEncoded) {
					config.data.doAsUserId = doAsUserIdEncoded;
				}

				const body = new URLSearchParams();

				Object.keys(config.data).forEach((key) => {
					if (Array.isArray(config.data[key])) {
						config.data[key].forEach((value) => {
							body.append(key, value);
						});
					}
					else {
						body.set(key, config.data[key]);
					}
				});

				Liferay.Util.fetch(
					themeDisplay.getPathMain() + '/portal/session_click',
					{
						body,
						method: 'POST',
					}
				)
					.then((response) => {
						if (config.dataType === 'json') {
							return response.json();
						}
						else {
							return response.text();
						}
					})
					.then((data) => {
						if (config.dataType === 'json') {
							if (
								Lang.isString(data) &&
								data.indexOf(TOKEN_SERIALIZE) === 0
							) {
								try {
									data = JSON.parse(
										data.substring(TOKEN_SERIALIZE.length)
									);
								}
								catch (error) {}
							}
						}

						if (typeof config.callback === 'function') {
							config.callback(data);
						}
					});
			},

			_setValues(data) {
				const instance = this;

				instance._ioRequest({
					data,
				});
			},

			get(key, callback) {
				const instance = this;

				instance._getValues('get', key, callback);
			},

			getAll(keys, callback) {
				const instance = this;

				instance._getValues('getAll', keys, callback);
			},

			set(key, value) {
				const instance = this;

				const object = {};

				if (isObject(value)) {
					value = TOKEN_SERIALIZE + JSON.stringify(value);
				}

				object[key] = value;

				instance._setValues(object);
			},

			setAll(object) {
				const instance = this;

				instance._setValues(object);
			},
		});

		Liferay.Store = Store;
	},
	''
);
