if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-surface-screen/aui-surface-screen.js']) {
   __coverage__['build/aui-surface-screen/aui-surface-screen.js'] = {"path":"build/aui-surface-screen/aui-surface-screen.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"(anonymous_2)","line":3,"loc":{"start":{"line":3,"column":15},"end":{"line":3,"column":26}}},"3":{"name":"(anonymous_3)","line":16,"loc":{"start":{"line":16,"column":14},"end":{"line":16,"column":25}}},"4":{"name":"(anonymous_4)","line":31,"loc":{"start":{"line":31,"column":22},"end":{"line":31,"column":33}}},"5":{"name":"(anonymous_5)","line":43,"loc":{"start":{"line":43,"column":10},"end":{"line":43,"column":29}}},"6":{"name":"(anonymous_6)","line":48,"loc":{"start":{"line":48,"column":25},"end":{"line":48,"column":43}}},"7":{"name":"(anonymous_7)","line":62,"loc":{"start":{"line":62,"column":16},"end":{"line":62,"column":27}}},"8":{"name":"(anonymous_8)","line":73,"loc":{"start":{"line":73,"column":16},"end":{"line":73,"column":27}}},"9":{"name":"(anonymous_9)","line":89,"loc":{"start":{"line":89,"column":23},"end":{"line":89,"column":34}}},"10":{"name":"(anonymous_10)","line":105,"loc":{"start":{"line":105,"column":10},"end":{"line":105,"column":21}}},"11":{"name":"(anonymous_11)","line":113,"loc":{"start":{"line":113,"column":14},"end":{"line":113,"column":25}}},"12":{"name":"(anonymous_12)","line":124,"loc":{"start":{"line":124,"column":12},"end":{"line":124,"column":26}}},"13":{"name":"(anonymous_13)","line":134,"loc":{"start":{"line":134,"column":14},"end":{"line":134,"column":25}}},"14":{"name":"(anonymous_14)","line":166,"loc":{"start":{"line":166,"column":20},"end":{"line":166,"column":31}}},"15":{"name":"(anonymous_15)","line":185,"loc":{"start":{"line":185,"column":14},"end":{"line":185,"column":32}}},"16":{"name":"(anonymous_16)","line":199,"loc":{"start":{"line":199,"column":16},"end":{"line":199,"column":27}}},"17":{"name":"(anonymous_17)","line":208,"loc":{"start":{"line":208,"column":16},"end":{"line":208,"column":27}}},"18":{"name":"(anonymous_18)","line":219,"loc":{"start":{"line":219,"column":14},"end":{"line":219,"column":25}}},"19":{"name":"(anonymous_19)","line":230,"loc":{"start":{"line":230,"column":19},"end":{"line":230,"column":33}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":258,"column":56}},"2":{"start":{"line":3,"column":0},"end":{"line":3,"column":29}},"3":{"start":{"line":5,"column":0},"end":{"line":5,"column":29}},"4":{"start":{"line":7,"column":0},"end":{"line":7,"column":45}},"5":{"start":{"line":9,"column":0},"end":{"line":137,"column":2}},"6":{"start":{"line":17,"column":8},"end":{"line":17,"column":56}},"7":{"start":{"line":32,"column":8},"end":{"line":32,"column":64}},"8":{"start":{"line":44,"column":8},"end":{"line":45,"column":29}},"9":{"start":{"line":47,"column":8},"end":{"line":47,"column":52}},"10":{"start":{"line":48,"column":8},"end":{"line":50,"column":11}},"11":{"start":{"line":49,"column":12},"end":{"line":49,"column":63}},"12":{"start":{"line":52,"column":8},"end":{"line":52,"column":53}},"13":{"start":{"line":63,"column":8},"end":{"line":63,"column":58}},"14":{"start":{"line":74,"column":8},"end":{"line":74,"column":58}},"15":{"start":{"line":90,"column":8},"end":{"line":90,"column":65}},"16":{"start":{"line":106,"column":8},"end":{"line":106,"column":66}},"17":{"start":{"line":114,"column":8},"end":{"line":114,"column":30}},"18":{"start":{"line":125,"column":8},"end":{"line":125,"column":49}},"19":{"start":{"line":135,"column":8},"end":{"line":135,"column":55}},"20":{"start":{"line":139,"column":0},"end":{"line":164,"column":2}},"21":{"start":{"line":166,"column":0},"end":{"line":166,"column":34}},"22":{"start":{"line":168,"column":0},"end":{"line":236,"column":2}},"23":{"start":{"line":186,"column":8},"end":{"line":191,"column":9}},"24":{"start":{"line":187,"column":12},"end":{"line":187,"column":33}},"25":{"start":{"line":190,"column":12},"end":{"line":190,"column":68}},"26":{"start":{"line":200,"column":8},"end":{"line":200,"column":26}},"27":{"start":{"line":209,"column":8},"end":{"line":209,"column":26}},"28":{"start":{"line":220,"column":8},"end":{"line":220,"column":26}},"29":{"start":{"line":231,"column":8},"end":{"line":233,"column":9}},"30":{"start":{"line":232,"column":12},"end":{"line":232,"column":30}},"31":{"start":{"line":234,"column":8},"end":{"line":234,"column":19}},"32":{"start":{"line":238,"column":0},"end":{"line":253,"column":2}},"33":{"start":{"line":255,"column":0},"end":{"line":255,"column":95}}},"branchMap":{"1":{"line":186,"type":"if","locations":[{"start":{"line":186,"column":8},"end":{"line":186,"column":8}},{"start":{"line":186,"column":8},"end":{"line":186,"column":8}}]},"2":{"line":231,"type":"if","locations":[{"start":{"line":231,"column":8},"end":{"line":231,"column":8}},{"start":{"line":231,"column":8},"end":{"line":231,"column":8}}]}},"code":["(function () { YUI.add('aui-surface-screen', function (A, NAME) {","","A.ScreenBase = function() {};","","A.ScreenBase.NAME = 'screen';","","A.ScreenBase._uniqueIdCounter = A.Lang.now();","","A.ScreenBase.prototype = {","    /**","     * Fires when the screen is active. Allows a screen to perform any setup","     * that requires its DOM to be visible. Lifecycle.","     *","     * @method activate","     */","    activate: function() {","        A.log('Screen [' + this + '] activate', 'info');","    },","","    /**","     * Gives the Screen a chance to cancel the navigation and stop itself from","     * being deactivated. Can be used, for example, if the screen has unsaved","     * state. Lifecycle.","     *","     * Clean-up should not be preformed here, since the navigation may still be","     * cancelled. Do clean-up in deactivate.","     *","     * @method beforeDeactivate","     * @return {Boolean}","     */","    beforeDeactivate: function() {","        A.log('Screen [' + this + '] beforeDeactivate', 'info');","    },","","    /**","     * Allows a screen to perform any setup immediately before the DOM is","     * made visible. Lifecycle.","     *","     * @method flip","     * @return {Promise} This can return a promise, which will pause the","     *     navigation until it is resolved.","     */","    flip: function(surfaces) {","        var instance = this,","            transitions = [];","","        A.log('Screen [' + this + '] flip', 'info');","        A.each(surfaces, function(surface) {","            transitions.push(surface.show(instance.get('id')));","        });","","        return A.CancellablePromise.all(transitions);","    },","","    /**","     * Allows a screen to do any cleanup necessary after it has been","     * deactivated, for example cancelling outstanding XHRs or stopping","     * timers. Lifecycle.","     *","     * @method deactivate","     */","    deactivate: function() {","        A.log('Screen [' + this + '] deactivate', 'info');","    },","","    /**","     * Destroy a screen, either after it is deactivated (in the case of a","     * non-cacheable view) or when the App is itself disposed for whatever","     * reason. Lifecycle.","     *","     * @method destructor","     */","    destructor: function() {","        A.log('Screen [' + this + '] destructor', 'info');","    },","","    /**","     * Returns the content for the given surface, or null if the surface isn't","     * used by this screen. This will be called when a screen is initially","     * constructed or, if a screen is non-cacheable, when navigated.","     *","     * @method getSurfaceContent","     * @param {String} surfaceId The id of the surface DOM element.","     * @param {String} opt_contents Optional content fetch by","     *     `getSurfacesContent`.","     * @return {String | Node} This can return a string or node representing the","     *     content of the surface.","     */","    getSurfaceContent: function() {","        A.log('Screen [' + this + '] getSurfaceContent', 'info');","    },","","    /**","     * Returns all contents for the surfaces. This will pass an `opt_contents`","     * to `getSurfaceContent` with all information you need to fulfill the","     * surfaces. Lifecycle.","     *","     * @method getSurfacesContent","     * @param {String} path The requested path.","     * @return {String | Promise} This can return a string representing the","     *     contents of the surfaces or a promise, which will pause the","     *     navigation until it is resolved. This is useful for loading async","     *     content.","     */","    load: function() {","        A.log('Screen [' + this + '] getSurfacesContent', 'info');","    },","","    /**","     * @method toString","     * @return {String}","     */","    toString: function() {","        return this.get('id');","    },","","    /**","     * Sets the id attribute.","     *","     * @method _setId","     * @param {String} val The screen id to be set.","     * @return {String} Value of the screen name concatenated with the id.","     */","    _setId: function(val) {","        return this.constructor.NAME + '_' + val;","    },","","    /**","     * Value of the id attribute.","     *","     * @method  _valueId","     * @return {String}","     */","    _valueId: function() {","        return String(A.ScreenBase._uniqueIdCounter++);","    }","};","","A.ScreenBase.ATTRS = {","    /**","     * The screen id.","     *","     * @attribute id","     * @writeOnce","     * @default Generated using `A.guid()`.","     * @type String","     */","    id: {","        setter: '_setId',","        validator: A.Lang.isString,","        valueFn: '_valueId',","        writeOnce: true","    },","","    /**","     * The document.title to set when the screen is active.","     *","     * @attribute title","     * @type {String}","     */","    title: {","        validator: A.Lang.isString","    }","};","","A.ScreenCacheable = function() {};","","A.ScreenCacheable.prototype = {","    /**","     * Holds the cached data.","     *","     * @property cache","     * @type {Object}","     * @protected","     */","    cache: null,","","    /**","     * Adds content to the cache.","     *","     * @method addCache","     * @param {String} surfaceId The id of the surface DOM element.","     * @param {String} content Content to be cached.","     */","    addCache: function(content) {","        if (this.get('cacheable')) {","            this.cache = content;","        }","        else {","            A.log('Screen [' + this + '] is not cacheable', 'info');","        }","    },","","    /**","     * Clears the cache.","     *","     * @method clearCache","     */","    clearCache: function() {","        this.cache = null;","    },","","    /**","     * Destroys a cacheable screen.","     *","     * @method destructor","     */","    destructor: function() {","        this.clearCache();","    },","","    /**","     * If the screen is cacheable returns the cached content for the surfaces.","     *","     * @method getCache","     * @protected","     * @return {Object} Cached content.","     */","    getCache: function() {","        return this.cache;","    },","","    /**","     * Sets the cache content.","     *","     * @method _setCacheable","     * @protected","     * @return {Object} Cached content.","     */","    _setCacheable: function(val) {","        if (!val) {","            this.clearCache();","        }","        return val;","    }","};","","A.ScreenCacheable.ATTRS = {","    /**","     * If false, the screen will be disposed after being deactivated.","     * If true, the surface content will be left in the DOM with","     * display:none.","     *","     * @attribute cacheable","     * @default false","     * @type Boolean","     */","    cacheable: {","        setter: '_setCacheable',","        validator: A.Lang.isBoolean,","        value: false","    }","};","","A.Screen = A.Base.create(A.ScreenBase.NAME, A.Base, [A.ScreenBase, A.ScreenCacheable], {}, {});","","","}, '3.1.0-deprecated.44', {\"requires\": [\"base-build\"]});","","}());"]};
}
var __cov_8k6nfK45D04nEUR2mPV__g = __coverage__['build/aui-surface-screen/aui-surface-screen.js'];
__cov_8k6nfK45D04nEUR2mPV__g.s['1']++;YUI.add('aui-surface-screen',function(A,NAME){__cov_8k6nfK45D04nEUR2mPV__g.f['1']++;__cov_8k6nfK45D04nEUR2mPV__g.s['2']++;A.ScreenBase=function(){__cov_8k6nfK45D04nEUR2mPV__g.f['2']++;};__cov_8k6nfK45D04nEUR2mPV__g.s['3']++;A.ScreenBase.NAME='screen';__cov_8k6nfK45D04nEUR2mPV__g.s['4']++;A.ScreenBase._uniqueIdCounter=A.Lang.now();__cov_8k6nfK45D04nEUR2mPV__g.s['5']++;A.ScreenBase.prototype={activate:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['3']++;__cov_8k6nfK45D04nEUR2mPV__g.s['6']++;A.log('Screen ['+this+'] activate','info');},beforeDeactivate:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['4']++;__cov_8k6nfK45D04nEUR2mPV__g.s['7']++;A.log('Screen ['+this+'] beforeDeactivate','info');},flip:function(surfaces){__cov_8k6nfK45D04nEUR2mPV__g.f['5']++;__cov_8k6nfK45D04nEUR2mPV__g.s['8']++;var instance=this,transitions=[];__cov_8k6nfK45D04nEUR2mPV__g.s['9']++;A.log('Screen ['+this+'] flip','info');__cov_8k6nfK45D04nEUR2mPV__g.s['10']++;A.each(surfaces,function(surface){__cov_8k6nfK45D04nEUR2mPV__g.f['6']++;__cov_8k6nfK45D04nEUR2mPV__g.s['11']++;transitions.push(surface.show(instance.get('id')));});__cov_8k6nfK45D04nEUR2mPV__g.s['12']++;return A.CancellablePromise.all(transitions);},deactivate:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['7']++;__cov_8k6nfK45D04nEUR2mPV__g.s['13']++;A.log('Screen ['+this+'] deactivate','info');},destructor:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['8']++;__cov_8k6nfK45D04nEUR2mPV__g.s['14']++;A.log('Screen ['+this+'] destructor','info');},getSurfaceContent:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['9']++;__cov_8k6nfK45D04nEUR2mPV__g.s['15']++;A.log('Screen ['+this+'] getSurfaceContent','info');},load:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['10']++;__cov_8k6nfK45D04nEUR2mPV__g.s['16']++;A.log('Screen ['+this+'] getSurfacesContent','info');},toString:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['11']++;__cov_8k6nfK45D04nEUR2mPV__g.s['17']++;return this.get('id');},_setId:function(val){__cov_8k6nfK45D04nEUR2mPV__g.f['12']++;__cov_8k6nfK45D04nEUR2mPV__g.s['18']++;return this.constructor.NAME+'_'+val;},_valueId:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['13']++;__cov_8k6nfK45D04nEUR2mPV__g.s['19']++;return String(A.ScreenBase._uniqueIdCounter++);}};__cov_8k6nfK45D04nEUR2mPV__g.s['20']++;A.ScreenBase.ATTRS={id:{setter:'_setId',validator:A.Lang.isString,valueFn:'_valueId',writeOnce:true},title:{validator:A.Lang.isString}};__cov_8k6nfK45D04nEUR2mPV__g.s['21']++;A.ScreenCacheable=function(){__cov_8k6nfK45D04nEUR2mPV__g.f['14']++;};__cov_8k6nfK45D04nEUR2mPV__g.s['22']++;A.ScreenCacheable.prototype={cache:null,addCache:function(content){__cov_8k6nfK45D04nEUR2mPV__g.f['15']++;__cov_8k6nfK45D04nEUR2mPV__g.s['23']++;if(this.get('cacheable')){__cov_8k6nfK45D04nEUR2mPV__g.b['1'][0]++;__cov_8k6nfK45D04nEUR2mPV__g.s['24']++;this.cache=content;}else{__cov_8k6nfK45D04nEUR2mPV__g.b['1'][1]++;__cov_8k6nfK45D04nEUR2mPV__g.s['25']++;A.log('Screen ['+this+'] is not cacheable','info');}},clearCache:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['16']++;__cov_8k6nfK45D04nEUR2mPV__g.s['26']++;this.cache=null;},destructor:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['17']++;__cov_8k6nfK45D04nEUR2mPV__g.s['27']++;this.clearCache();},getCache:function(){__cov_8k6nfK45D04nEUR2mPV__g.f['18']++;__cov_8k6nfK45D04nEUR2mPV__g.s['28']++;return this.cache;},_setCacheable:function(val){__cov_8k6nfK45D04nEUR2mPV__g.f['19']++;__cov_8k6nfK45D04nEUR2mPV__g.s['29']++;if(!val){__cov_8k6nfK45D04nEUR2mPV__g.b['2'][0]++;__cov_8k6nfK45D04nEUR2mPV__g.s['30']++;this.clearCache();}else{__cov_8k6nfK45D04nEUR2mPV__g.b['2'][1]++;}__cov_8k6nfK45D04nEUR2mPV__g.s['31']++;return val;}};__cov_8k6nfK45D04nEUR2mPV__g.s['32']++;A.ScreenCacheable.ATTRS={cacheable:{setter:'_setCacheable',validator:A.Lang.isBoolean,value:false}};__cov_8k6nfK45D04nEUR2mPV__g.s['33']++;A.Screen=A.Base.create(A.ScreenBase.NAME,A.Base,[A.ScreenBase,A.ScreenCacheable],{},{});},'3.1.0-deprecated.44',{'requires':['base-build']});
