Liferay.Loader.define("frontend-image-editor-web@4.0.20/ResizeComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ResizeComponent.soy', './ResizeControls.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ResizeComponent = _interopRequireDefault(require("./ResizeComponent.soy"));

  require("./ResizeControls.soy");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Resize component.
   */
  var ResizeComponent = /*#__PURE__*/function (_Component) {
    _inherits(ResizeComponent, _Component);

    function ResizeComponent() {
      _classCallCheck(this, ResizeComponent);

      return _possibleConstructorReturn(this, _getPrototypeOf(ResizeComponent).apply(this, arguments));
    }

    _createClass(ResizeComponent, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        var _this = this;

        this.getImageEditorImageData().then(function (imageData) {
          _this.imageWidth = imageData.width;
          _this.imageHeight = imageData.height;
          _this.imageRatio_ = _this.imageWidth / _this.imageHeight;
          _this.imageHeightInput_ = _this.element.querySelector('#' + _this.ref + 'Height');
          _this.imageWidthInput_ = _this.element.querySelector('#' + _this.ref + 'Width');
          _this.lockProportions = true;
        });
      }
      /**
       * Executes the resize operation to get the final version of the image.
       *
       * @param  {ImageData} imageData The image data representation of the image.
       * @return {Promise} A promise that resolves with the resized
       * image data representation.
       */

    }, {
      key: "process",
      value: function process(imageData) {
        return Promise.resolve(this.resizeImageData_(imageData));
      }
      /**
       * Resizes image data to the user's selected width and height values.
       *
       * @param  {ImageData} imageData The original image data.
       * @return {ImageData} The resized image data with the component width and
       * height values specified by the user.
       */

    }, {
      key: "resizeImageData_",
      value: function resizeImageData_(imageData) {
        var rawCanvas = document.createElement('canvas');
        rawCanvas.width = imageData.width;
        rawCanvas.height = imageData.height;
        rawCanvas.getContext('2d').putImageData(imageData, 0, 0);
        var canvas = document.createElement('canvas');
        canvas.width = this.imageWidth;
        canvas.height = this.imageHeight;
        var context = canvas.getContext('2d');
        context.drawImage(rawCanvas, 0, 0, this.imageWidth, this.imageHeight);
        return context.getImageData(0, 0, this.imageWidth, this.imageHeight);
      }
      /**
       * Keeps the width/height ratio in sync when <code>lockProportions</code> is
       * <code>true</code>.
       *
       * @param  {InputEvent} event The input event.
       */

    }, {
      key: "syncDimensions",
      value: function syncDimensions(event) {
        var newValue = parseInt(event.delegateTarget.value, 10);

        if (event.delegateTarget === this.imageWidthInput_) {
          this.imageWidth = newValue;

          if (this.lockProportions) {
            this.imageHeight = parseInt(newValue / this.imageRatio_, 10);
            this.imageHeightInput_.value = this.imageHeight;
          }
        } else {
          this.imageHeight = newValue;

          if (this.lockProportions) {
            this.imageWidth = parseInt(newValue * this.imageRatio_, 10);
            this.imageWidthInput_.value = this.imageWidth;
          }
        }
      }
      /**
       * Toggles the value of the <code>lockProportions</code> attribute. When
       * enabled, changes in one of the dimensions cascades changes to the other
       * to keep the original image ratio.
       */

    }, {
      key: "toggleLockProportions",
      value: function toggleLockProportions() {
        this.lockProportions = !this.lockProportions;
      }
    }]);

    return ResizeComponent;
  }(_metalComponent["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  ResizeComponent.STATE = {
    /**
     * Injected helper that retrieves the editor image data.
     *
     * @type {Function}
     */
    getImageEditorImageData: {
      validator: _metal.core.isFunction
    }
  };

  _metalSoy["default"].register(ResizeComponent, _ResizeComponent["default"]);

  var _default = ResizeComponent;
  exports["default"] = _default;
  //# sourceMappingURL=ResizeComponent.es.js.map
});
//# sourceMappingURL=ResizeComponent.es.js.map