Liferay.Loader.define("frontend-image-editor-web@4.0.20/ImageEditorHistoryEntry.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Image Editor History Entry
   *
   * This class models a step in the image edition process. It stores the
   * Image data at a given point in time so it can be later recovered for
   * undo/redo purposes or other visualization needs.
   * @review
   */
  var ImageEditorHistoryEntry = /*#__PURE__*/function () {
    /**
     * Constructor
     * @review
     */
    function ImageEditorHistoryEntry(image) {
      var _this = this;

      _classCallCheck(this, ImageEditorHistoryEntry);

      this.dataPromise_ = new Promise(function (resolve) {
        // Preemtively fetch the imageData when all we have is the image url
        if (image.url && !image.data) {
          _this.loadData_(image.url).then(function (imageData) {
            return resolve(imageData);
          });
        } else {
          resolve(image.data);
        }
      });
    }
    /**
     * Fetches an ImageData for a given image url
     * @param  {String} imageURL The image url to load
     * @protected
     * @review
     */

    _createClass(ImageEditorHistoryEntry, [{
      key: "loadData_",
      value: function loadData_(imageURL) {
        return new Promise(function (resolve) {
          var bufferImage = new Image();

          bufferImage.onload = function () {
            var bufferCanvas = document.createElement('canvas');
            var bufferContext = bufferCanvas.getContext('2d');
            var height = bufferImage.height;
            var width = bufferImage.width;
            bufferCanvas.width = width;
            bufferCanvas.height = height;
            bufferContext.drawImage(bufferImage, 0, 0, width, height);
            resolve(bufferContext.getImageData(0, 0, width, height));
          };

          bufferImage.src = imageURL;
        });
      }
      /**
       * Fetches the stored ImageData of this history entry
       * @return {Promise} A promise that will resolve with the stored ImageData value
       * @review
       */

    }, {
      key: "getImageData",
      value: function getImageData() {
        return this.dataPromise_;
      }
    }]);

    return ImageEditorHistoryEntry;
  }();

  var _default = ImageEditorHistoryEntry;
  exports["default"] = _default;
  //# sourceMappingURL=ImageEditorHistoryEntry.es.js.map
});
//# sourceMappingURL=ImageEditorHistoryEntry.es.js.map