/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.web.internal.portlet.tracker;

import com.liferay.frontend.image.editor.capability.ImageEditorCapability;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ImageEditorCapabilityTracker.class})
public class ImageEditorCapabilityTracker {
    private static final Log _log = LogFactoryUtil.getLog(ImageEditorCapabilityTracker.class);
    private BundleContext _bundleContext;
    private volatile Set<String> _imageEditorCapabilitiesRequirements = Collections.emptySet();
    private ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>> _serviceTrackerMap;

    public Set<String> getImageEditorCapabilitiesRequirements() {
        return this._imageEditorCapabilitiesRequirements;
    }

    public List<ImageEditorCapabilityDescriptor> getImageEditorCapabilityDescriptors(String imageEditorCapabilityType) {
        return (List)this._serviceTrackerMap.getService((Object)imageEditorCapabilityType);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ImageEditorCapability.class, (String)"(com.liferay.frontend.image.editor.capability.type=*)", (ServiceReferenceMapper)new PropertyServiceReferenceMapper("com.liferay.frontend.image.editor.capability.type"), (ServiceTrackerCustomizer)new ImageEditorCapabilityDescriptorServiceTrackerCustomizer(), (Comparator)new PropertyServiceReferenceComparator("service.ranking"), (ServiceTrackerMapListener)new ImageEditorCapabilityServiceTrackerMapListener());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getJavaScriptFileName(String fileName) {
        return StringUtil.removeSubstring((String)FileUtil.getShortFileName((String)fileName), (String)".js");
    }

    private Set<String> _rebuildImageEditorCapabilitiesRequirements(ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>> serviceTrackerMap) {
        HashSet<String> requiredModules = new HashSet<String>();
        for (String key : serviceTrackerMap.keySet()) {
            List imageEditorCapabilityDescriptors = (List)serviceTrackerMap.getService((Object)key);
            for (ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor : imageEditorCapabilityDescriptors) {
                try {
                    ImageEditorCapability imageEditorCapability = imageEditorCapabilityDescriptor.getImageEditorCapability();
                    String moduleName = imageEditorCapability.getModuleName();
                    List resourceURLs = imageEditorCapability.getResourceURLs();
                    for (URL resourceURL : resourceURLs) {
                        String fileName = this._getJavaScriptFileName(resourceURL.getFile());
                        requiredModules.add(StringBundler.concat((String[])new String[]{moduleName, "/", fileName}));
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
            }
        }
        return requiredModules;
    }

    private class ImageEditorCapabilityServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, ImageEditorCapabilityDescriptor, List<ImageEditorCapabilityDescriptor>> {
        private ImageEditorCapabilityServiceTrackerMapListener() {
        }

        public synchronized void keyEmitted(ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>> serviceTrackerMap, String key, ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor, List<ImageEditorCapabilityDescriptor> imageEditorCapabilityDescriptors) {
            ImageEditorCapabilityTracker.this._imageEditorCapabilitiesRequirements = ImageEditorCapabilityTracker.this._rebuildImageEditorCapabilitiesRequirements((ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>>)serviceTrackerMap);
        }

        public synchronized void keyRemoved(ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>> serviceTrackerMap, String key, ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor, List<ImageEditorCapabilityDescriptor> imageEditorCapabilityDescriptors) {
            ImageEditorCapabilityTracker.this._imageEditorCapabilitiesRequirements = ImageEditorCapabilityTracker.this._rebuildImageEditorCapabilitiesRequirements((ServiceTrackerMap<String, List<ImageEditorCapabilityDescriptor>>)serviceTrackerMap);
        }
    }

    private class ImageEditorCapabilityDescriptorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ImageEditorCapability, ImageEditorCapabilityDescriptor> {
        private ImageEditorCapabilityDescriptorServiceTrackerCustomizer() {
        }

        public ImageEditorCapabilityDescriptor addingService(ServiceReference<ImageEditorCapability> serviceReference) {
            String[] propertyKeys;
            ImageEditorCapability imageEditorCapability = (ImageEditorCapability)ImageEditorCapabilityTracker.this._bundleContext.getService(serviceReference);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String propertyKey : propertyKeys = serviceReference.getPropertyKeys()) {
                properties.put(propertyKey, serviceReference.getProperty(propertyKey));
            }
            try {
                return new ImageEditorCapabilityDescriptor(imageEditorCapability, properties);
            }
            catch (Exception exception) {
                ImageEditorCapabilityTracker.this._bundleContext.ungetService(serviceReference);
                return null;
            }
        }

        public void modifiedService(ServiceReference<ImageEditorCapability> serviceReference, ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor) {
            this.removedService(serviceReference, imageEditorCapabilityDescriptor);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<ImageEditorCapability> serviceReference, ImageEditorCapabilityDescriptor imageEditorCapabilityDescriptor) {
            ImageEditorCapabilityTracker.this._bundleContext.ungetService(serviceReference);
        }
    }

    public static class ImageEditorCapabilityDescriptor {
        private final ImageEditorCapability _imageEditorCapability;
        private final Map<String, Object> _properties;

        public ImageEditorCapabilityDescriptor(ImageEditorCapability imageEditorCapability, Map<String, Object> properties) {
            this._imageEditorCapability = imageEditorCapability;
            this._properties = properties;
        }

        public ImageEditorCapability getImageEditorCapability() {
            return this._imageEditorCapability;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }
    }
}

