/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.image.editor.integration.document.library.internal.display.context;

import com.liferay.document.library.display.context.BaseDLViewFileVersionDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.frontend.image.editor.integration.document.library.internal.display.context.logic.ImageEditorDLDisplayContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageEditorDLViewFileVersionDisplayContext
extends BaseDLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("ec0c6ec4-8671-4c9e-94a3-8c6bcca0437c");
    private final FileEntry _fileEntry;
    private final ImageEditorDLDisplayContextHelper _imageEditorDLDisplayContextHelper;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final ThemeDisplay _themeDisplay;

    public ImageEditorDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLDisplayContext, HttpServletRequest request, HttpServletResponse response, FileVersion fileVersion, ResourceBundleLoader resourceBundleLoader) {
        super(_UUID, parentDLDisplayContext, request, response, fileVersion);
        this._resourceBundleLoader = resourceBundleLoader;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            FileEntry fileEntry = null;
            if (fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            this._fileEntry = fileEntry;
            this._imageEditorDLDisplayContextHelper = new ImageEditorDLDisplayContextHelper(fileVersion, request);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to create image editor document library view file version display context for file version " + fileVersion, (Throwable)pe);
        }
    }

    public Menu getMenu() throws PortalException {
        Menu menu = super.getMenu();
        List menuItems = menu.getMenuItems();
        if (!this._imageEditorDLDisplayContextHelper.isShowImageEditorAction()) {
            return menu;
        }
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(this._themeDisplay.getLocale());
        ImageEditorDLDisplayContextHelper imageEditorDLDisplayContextHelper = new ImageEditorDLDisplayContextHelper(this.fileVersion, this.request);
        menuItems.add(imageEditorDLDisplayContextHelper.getJavacriptEditWithImageEditorMenuItem(resourceBundle));
        return menu;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        List toolbarItems = super.getToolbarItems();
        if (!this._imageEditorDLDisplayContextHelper.isShowImageEditorAction()) {
            return toolbarItems;
        }
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(this._themeDisplay.getLocale());
        ImageEditorDLDisplayContextHelper imageEditorDLDisplayContextHelper = new ImageEditorDLDisplayContextHelper(this.fileVersion, this.request);
        toolbarItems.add(imageEditorDLDisplayContextHelper.getJavacriptEditWithImageEditorToolbarItem(resourceBundle));
        return toolbarItems;
    }
}

