Liferay.Loader.define("frontend-image-editor-capability-resize@2.0.1/ResizeComponent.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-promise/src/promise/Promise', 'metal/src/metal', './ResizeComponent.soy', './ResizeControls.soy'], function (exports, _component, _Soy, _Promise, _metal, _ResizeComponent, _ResizeControls) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _ResizeComponent2 = _interopRequireDefault(_ResizeComponent);

	var _ResizeControls2 = _interopRequireDefault(_ResizeControls);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ResizeComponent = function (_Component) {
		_inherits(ResizeComponent, _Component);

		function ResizeComponent() {
			_classCallCheck(this, ResizeComponent);

			return _possibleConstructorReturn(this, (ResizeComponent.__proto__ || Object.getPrototypeOf(ResizeComponent)).apply(this, arguments));
		}

		_createClass(ResizeComponent, [{
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				this.getImageEditorImageData().then(function (imageData) {
					_this2.imageWidth = imageData.width;
					_this2.imageHeight = imageData.height;

					_this2.imageRatio_ = _this2.imageWidth / _this2.imageHeight;

					_this2.imageHeightInput_ = _this2.element.querySelector('#' + _this2.ref + 'Height');
					_this2.imageWidthInput_ = _this2.element.querySelector('#' + _this2.ref + 'Width');

					_this2.lockProportions = true;
				});
			}
		}, {
			key: 'process',
			value: function process(imageData) {
				return _Promise.CancellablePromise.resolve(this.resizeImageData_(imageData));
			}
		}, {
			key: 'resizeImageData_',
			value: function resizeImageData_(imageData) {
				var rawCanvas = document.createElement('canvas');
				rawCanvas.width = imageData.width;
				rawCanvas.height = imageData.height;

				rawCanvas.getContext('2d').putImageData(imageData, 0, 0);

				var canvas = document.createElement('canvas');
				canvas.width = this.imageWidth;
				canvas.height = this.imageHeight;

				var context = canvas.getContext('2d');
				context.drawImage(rawCanvas, 0, 0, this.imageWidth, this.imageHeight);

				return context.getImageData(0, 0, this.imageWidth, this.imageHeight);
			}
		}, {
			key: 'syncDimensions',
			value: function syncDimensions(event) {
				var newValue = parseInt(event.delegateTarget.value, 10);

				if (event.delegateTarget === this.imageWidthInput_) {
					this.imageWidth = newValue;

					if (this.lockProportions) {
						this.imageHeight = parseInt(newValue / this.imageRatio_, 10);
						this.imageHeightInput_.value = this.imageHeight;
					}
				} else {
					this.imageHeight = newValue;

					if (this.lockProportions) {
						this.imageWidth = parseInt(newValue * this.imageRatio_, 10);
						this.imageWidthInput_.value = this.imageWidth;
					}
				}
			}
		}, {
			key: 'toggleLockProportions',
			value: function toggleLockProportions(event) {
				this.lockProportions = !this.lockProportions;
			}
		}]);

		return ResizeComponent;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */
	ResizeComponent.STATE = {
		/**
   * Injected helper to get the editor image data
   * @review
   * @type {Function}
   */
		getImageEditorImageData: {
			validator: _metal.core.isFunction
		}
	};

	_Soy2.default.register(ResizeComponent, _ResizeComponent2.default);

	exports.default = ResizeComponent;
});
//# sourceMappingURL=ResizeComponent.es.js.map
