/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.tinymce.web.internal.editor.configuration;

import com.liferay.frontend.editor.tinymce.web.internal.editor.configuration.BaseTinyMCEEditorConfigContributor;
import com.liferay.item.selector.ItemSelector;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.TextFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=tinymce"}, service={EditorConfigContributor.class})
public class TinyMCEEditorConfigContributor
extends BaseTinyMCEEditorConfigContributor {
    @Reference
    private BrowserSniffer _browserSniffer;
    @Reference
    private ItemSelector _itemSelector;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("mode", "exact").put("plugins", this.getPluginsJSONArray(inputEditorTaglibAttributes)).put("style_formats", this.getStyleFormatsJSONArray(themeDisplay.getLocale())).put("toolbar", this.getToolbarJSONArray(inputEditorTaglibAttributes, themeDisplay));
    }

    @Override
    protected ItemSelector getItemSelector() {
        return this._itemSelector;
    }

    protected JSONArray getPluginsJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONUtil.putAll((Object[])new Object[]{"advlist autolink autosave link image lists charmap print preview hr anchor", "searchreplace wordcount fullscreen media"});
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put("code");
        }
        jsonArray.put("table contextmenu emoticons textcolor paste fullpage textcolor colorpicker textpattern");
        return jsonArray;
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String type, String element, String cssClasses) {
        return JSONUtil.put((String)type, (Object)element).put("classes", cssClasses).put("title", styleFormatName);
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "inline", "p", null), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "block", "h1", null), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "block", "h2", null), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "block", "h3", null), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "block", "h4", null), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"preformatted-text"), "block", "pre", null), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "inline", "cite", null), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "inline", "code", null), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"info-message"), "block", "div", "portlet-msg-info"), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"alert-message"), "block", "div", "portlet-msg-alert"), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"error-message"), "block", "div", "portlet-msg-error")});
    }

    protected JSONArray getToolbarJSONArray(Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay) {
        JSONArray toolbarJSONArray;
        JSONObject toolbarsJSONObject = this.getToolbarsJSONObject(inputEditorTaglibAttributes);
        String toolbarSet = (String)inputEditorTaglibAttributes.get("liferay-ui:input-editor:toolbarSet");
        String currentToolbarSet = TextFormatter.format((String)HtmlUtil.escapeJS((String)toolbarSet), (int)12);
        if (this._browserSniffer.isMobile(themeDisplay.getRequest())) {
            currentToolbarSet = "phone";
        }
        if ((toolbarJSONArray = toolbarsJSONObject.getJSONArray(currentToolbarSet)) == null) {
            toolbarJSONArray = toolbarsJSONObject.getJSONArray("liferay");
        }
        return toolbarJSONArray;
    }

    protected JSONArray getToolbarsEmailJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONUtil.put((Object)"fontselect fontsizeselect | forecolor backcolor | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify");
        String buttons = "cut copy paste bullist numlist | blockquote | undo redo | link unlink image ";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + "code ";
        }
        buttons = buttons + "| hr removeformat | preview print fullscreen";
        jsonArray.put(buttons);
        return jsonArray;
    }

    protected JSONObject getToolbarsJSONObject(Map<String, Object> inputEditorTaglibAttributes) {
        return JSONUtil.put((String)"email", (Object)this.getToolbarsEmailJSONArray(inputEditorTaglibAttributes)).put("liferay", this.getToolbarsLiferayJSONArray(inputEditorTaglibAttributes)).put("phone", this.getToolbarsPhoneJSONArray()).put("simple", this.getToolbarsSimpleJSONArray(inputEditorTaglibAttributes)).put("tablet", this.getToolbarsTabletJSONArray(inputEditorTaglibAttributes));
    }

    protected JSONArray getToolbarsLiferayJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        String buttons = "cut copy paste searchreplace bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media ";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + "code";
        }
        return JSONUtil.putAll((Object[])new Object[]{"styleselect fontselect fontsizeselect | forecolor backcolor | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify", buttons, "table | hr removeformat | subscript superscript | charmap emoticons | preview print fullscreen"});
    }

    protected JSONArray getToolbarsPhoneJSONArray() {
        return JSONUtil.putAll((Object[])new Object[]{"bold italic underline | bullist numlist", "link unlink image"});
    }

    protected JSONArray getToolbarsSimpleJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        String buttons = "bold italic underline strikethrough | bullist numlist | table | link unlink image";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + " code";
        }
        return JSONUtil.put((Object)buttons);
    }

    protected JSONArray getToolbarsTabletJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONUtil.put((Object)"styleselect fontselect fontsizeselect | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify");
        String buttons = "bullist numlist | link unlink image";
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            buttons = buttons + " code";
        }
        jsonArray.put(buttons);
        return jsonArray;
    }
}

