/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration.BaseAlloyEditorConfigContributor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.name=alloyeditor_bbcode"}, service={EditorConfigContributor.class})
public class AlloyEditorBBCodeConfigContributor
extends BaseAlloyEditorConfigContributor {
    private static final int _CKEDITOR_STYLE_BLOCK = 1;
    private static final int _CKEDITOR_STYLE_INLINE = 2;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("allowedContent", (Object)Boolean.TRUE).put("enterMode", 1);
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = extraPlugins.concat(",bbcode,itemselector");
        jsonObject.put("extraPlugins", extraPlugins).put("forceEnterMode", (Object)Boolean.TRUE).put("format_tags", "p;pre").put("lang", this.getLangJSONObject(inputEditorTaglibAttributes)).put("newThreadURL", "${newThreadURL}");
        String removePlugins = jsonObject.getString("removePlugins");
        StringBundler sb = new StringBundler(3);
        sb.append("bidi,div,flash,font,forms,indentblock,keystrokes,maximize,");
        sb.append("newpage,pagebreak,preview,print,save,showblocks,smiley,");
        sb.append("stylescombo,templates,video");
        jsonObject.put("removePlugins", removePlugins.concat(",").concat(sb.toString())).put("smiley_images", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonFiles())).put("smiley_path", HtmlUtil.escape((String)themeDisplay.getPathThemeImages()) + "/emoticons/").put("smiley_symbols", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonSymbols())).put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    protected JSONObject getLangJSONObject(Map<String, Object> inputEditorTaglibAttributes) {
        return JSONUtil.put((String)"code", (Object)LanguageUtil.get((Locale)this.getContentsLocale(inputEditorTaglibAttributes), (String)"code"));
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass, int type) {
        return JSONUtil.put((String)"name", (Object)styleFormatName).put("style", this.getStyleJSONObject(element, cssClass, type));
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        return JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"normal"), "p", null, 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"cited-work"), "cite", null, 2), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"computer-code"), "code", null, 2)});
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        JSONObject stylesJSONObject = JSONUtil.put((String)"styles", (Object)this.getStyleFormatsJSONArray(locale));
        return JSONUtil.put((String)"cfg", (Object)stylesJSONObject).put("name", "styles");
    }

    protected JSONObject getStyleJSONObject(String element, String cssClass, int type) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            JSONObject attributesJSONObject = JSONUtil.put((String)"class", (Object)cssClass);
            styleJSONObject.put("attributes", attributesJSONObject);
        }
        styleJSONObject.put("element", element).put("type", type);
        return styleJSONObject;
    }

    protected JSONObject getToolbarsAddJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)JSONUtil.put((Object)"image")).put("tabIndex", 2);
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        return JSONUtil.put((String)"add", (Object)this.getToolbarsAddJSONObject()).put("styles", this.getToolbarsStylesJSONObject(locale));
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        return JSONUtil.put((String)"selections", (Object)this.getToolbarsStylesSelectionsJSONArray(locale)).put("tabIndex", 1);
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        return JSONUtil.putAll((Object[])new Object[]{this.getToolbarsStylesSelectionsLinkJSONObject(), this.getToolbarsStylesSelectionsTextJSONObject(locale)});
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['linkEditBrowse']")).put("name", "link").put("test", "AlloyEditor.SelectionTest.link");
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        return JSONUtil.put((String)"buttons", (Object)JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatsJSONObject(locale), "bold", "italic", "underline", "ol", "ul", "linkBrowse", "quote"})).put("name", "text").put("test", "AlloyEditor.SelectionTest.text");
    }
}

