/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.api.embed.EditorEmbedProvider;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(property={"editor.name=alloyeditor"}, service={EditorConfigContributor.class})
public class AlloyEditorEmbedConfigContributor
extends BaseEditorConfigContributor {
    private ServiceTrackerMap<String, List<EditorEmbedProvider>> _serviceTrackerMap;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        jsonObject.put("embedProviders", this.getEditorEmbedProvidersJSONArray());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, EditorEmbedProvider.class, null, (serviceReference, emitter) -> {
            String type = (String)serviceReference.getProperty("type");
            if (Validator.isNull((String)type)) {
                type = "unknown";
            }
            emitter.emit((Object)type);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected JSONObject getEditorEmbedProviderJSONObject(String editorEmbedProviderType, EditorEmbedProvider editorEmbedProvider) {
        String[] urlSchemes;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("id", editorEmbedProvider.getId());
        jsonObject.put("tpl", editorEmbedProvider.getTpl());
        jsonObject.put("type", editorEmbedProviderType);
        JSONArray urlSchemesJSONArray = JSONFactoryUtil.createJSONArray();
        jsonObject.put("urlSchemes", urlSchemesJSONArray);
        for (String urlScheme : urlSchemes = editorEmbedProvider.getURLSchemes()) {
            urlSchemesJSONArray.put(urlScheme);
        }
        return jsonObject;
    }

    protected JSONArray getEditorEmbedProvidersJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Set editorEmbedProviderTypes = this._serviceTrackerMap.keySet();
        editorEmbedProviderTypes.forEach(editorEmbedProviderType -> {
            List editorEmbedProviders = (List)this._serviceTrackerMap.getService(editorEmbedProviderType);
            editorEmbedProviders.forEach(editorEmbedProvider -> jsonArray.put(this.getEditorEmbedProviderJSONObject((String)editorEmbedProviderType, (EditorEmbedProvider)editorEmbedProvider)));
        });
        return jsonArray;
    }
}

