(function() {
this.AlloyEditor.Buttons = this.AlloyEditor.Buttons || {};
this.AlloyEditor.ButtonsNamed = this.AlloyEditor.ButtonsNamed || {};
var babelHelpers = {};

babelHelpers.extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

babelHelpers;
'use strict';

(function () {
	/* global React, ReactDOM AlloyEditor */

	(function () {
		'use strict';

		var React = AlloyEditor.React;

		/**
   * The ButtonLinkBrowse class provides functionality for creating and editing a link in a document,
   * and also allows to link to an existing file in DM.
   * ButtonLinkBrowse renders in two different modes:
   *
   * - Normal: Just a button that allows to switch to the edition mode
   * - Exclusive: The ButtonLinkEditBrowse UI with all the link edition controls.
   *
   * @uses ButtonKeystroke
   * @uses ButtonStateClasses
   * @uses ButtonCfgProps
   *
   * @class ButtonLinkBrowse
   */
		var ButtonLinkBrowse = React.createClass({
			displayName: 'ButtonLinkBrowse',

			mixins: [AlloyEditor.ButtonKeystroke, AlloyEditor.ButtonStateClasses, AlloyEditor.ButtonCfgProps],

			// Allows validating props being passed to the component.
			propTypes: {
				/**
     * The editor instance where the component is being used.
     *
     * @property {Object} editor
     */
				editor: React.PropTypes.object.isRequired,

				/**
     * The label that should be used for accessibility purposes.
     *
     * @property {String} label
     */
				label: React.PropTypes.string,

				/**
     * The tabIndex of the button in its toolbar current state. A value other than -1
     * means that the button has focus and is the active element.
     *
     * @property {Number} tabIndex
     */
				tabIndex: React.PropTypes.number
			},

			// Lifecycle. Provides static properties to the widget.
			statics: {
				key: 'linkBrowse'
			},

			/**
    * Lifecycle. Returns the default values of the properties used in the widget.
    *
    * @method getDefaultProps
    * @return {Object} The default properties.
    */
			getDefaultProps: function getDefaultProps() {
				return {
					keystroke: {
						fn: '_requestExclusive',
						keys: CKEDITOR.CTRL + 76 /*L*/
					}
				};
			},

			/**
    * Lifecycle. Renders the UI of the button.
    *
    * @method render
    * @return {Object} The content which should be rendered.
    */
			render: function render() {
				if (this.props.renderExclusive) {
					var props = this.mergeButtonCfgProps();

					return React.createElement(AlloyEditor.ButtonLinkEditBrowse, this.props);
				} else {
					return React.createElement(AlloyEditor.ButtonLink, this.props);
				}
			},


			/**
    * Requests the link button to be rendered in exclusive mode to allow the creation of a link.
    *
    * @protected
    * @method _requestExclusive
    */
			_requestExclusive: function _requestExclusive() {
				this.props.requestExclusive(ButtonLinkBrowse.key);
			}
		});

		AlloyEditor.Buttons[ButtonLinkBrowse.key] = AlloyEditor.ButtonLinkBrowse = ButtonLinkBrowse;
	})();
}).call(this);
"use strict";

(function () {
	/* global React, ReactDOM AlloyEditor */

	(function () {
		'use strict';

		var React = AlloyEditor.React;

		/**
   * The FolderIconSvg class renders a folder icon.
   *
   * @class FolderIconSvg
   */
		var FolderIconSvg = React.createClass({
			displayName: "FolderIconSvg",

			/**
    * Lifecycle. Renders the UI of the button.
    *
    * @method render
    * @return {Object} The content which should be rendered.
    */
			render: function render() {
				return React.createElement(
					"svg",
					{ width: "19px", height: "16px", viewBox: "0 0 19 16", version: "1.1" },
					React.createElement(
						"g",
						{ stroke: "none", "stroke-width": "1", fill: "none", "fill-rule": "evenodd" },
						React.createElement(
							"g",
							{ id: "folder_icon", "fill-rule": "nonzero", fill: "#FFFFFF" },
							React.createElement("path", { d: "M1.16154142e-20,3.2 L7.82504921e-20,13.8932647 C8.51581999e-20,15.0017792 0.890925393,15.9004077 1.99742191,15.9004077 L17.0025781,15.9004077 C18.1057238,15.9004077 19,15.0109745 19,13.8961809 L19,5.25591756 C19,4.14901366 18.1131578,3.24410791 16.9941243,3.2350902 C16.9941243,3.2350902 13.9000228,3.20635475 11.1841707,3.2 L5.55111512e-16,3.2 Z M0.00476820776,1.92 C0.0763137892,0.875650807 0.944078934,0.0525431571 2.00404495,0.0525431571 L6.37206813,0.0525431571 C7.69758986,0.0525431571 8.07530451,1.04873135 8.52730884,1.92 L0.00476820776,1.92 Z" })
						)
					)
				);
			}
		});

		/**
   * The ButtonLinkEditBrowse class provides functionality for creating and editing a link in a document,
   * and also allows to link to an existing file in DM.
   * Provides UI for creating, editing and removing a link.
   *
   * @uses WidgetDropdown
   * @uses WidgetFocusManager
   * @uses ButtonCfgProps
   *
   * @class ButtonLinkEditBrowse
   */
		var ButtonLinkEditBrowse = React.createClass({
			displayName: "ButtonLinkEditBrowse",

			// Allows validating props being passed to the component.
			propTypes: {
				/**
     * The editor instance where the component is being used.
     *
     * @property {Object} editor
     */
				editor: React.PropTypes.object.isRequired
			},

			// Lifecycle. Provides static properties to the widget.
			statics: {
				/**
     * The name which will be used as an alias of the button in the configuration.
     *
     * @static
     * @property {String} key
     * @default linkEdit
     */
				key: 'linkEditBrowse'
			},

			/**
    * Lifecycle. Invoked once before the component is mounted.
    * The return value will be used as the initial value of this.state.
    *
    * @method getInitialState
    */
			getInitialState: function getInitialState() {
				var link = new CKEDITOR.Link(this.props.editor.get('nativeEditor')).getFromSelection();
				var href = link ? link.getAttribute('href') : '';

				return {
					element: link,
					linkHref: href
				};
			},

			/**
    * Lifecycle. Renders the UI of the button.
    *
    * @method render
    * @return {Object} The content which should be rendered.
    */
			render: function render() {
				return React.createElement(
					"div",
					null,
					React.createElement(AlloyEditor.ButtonLinkEdit, babelHelpers.extends({ ref: "linkEditButton" }, this.props)),
					React.createElement(
						"button",
						{ "aria-label": "Browse", className: "ae-button", onClick: this._browseClick, title: "browse" },
						React.createElement(FolderIconSvg, null)
					)
				);
			},

			/**
    * Opens an item selector dialog.
    *
    * @protected
    * @method _browseClick
    */
			_browseClick: function _browseClick() {
				var instance = this;

				var editor = this.props.editor.get('nativeEditor');

				var url = editor.config.documentBrowseLinkUrl;

				var linkTarget = this.refs.linkEditButton.state.linkTarget;

				AUI().use('liferay-item-selector-dialog', function (A) {
					var itemSelectorDialog = new A.LiferayItemSelectorDialog({
						eventName: editor.name + 'selectDocument',
						on: {
							selectedItemChange: function selectedItemChange(event) {
								var selectedItem = event.newVal;

								if (selectedItem) {
									instance._updateLink(selectedItem.value, linkTarget);
								}
							}
						},
						title: Liferay.Language.get('select-item'),
						url: url
					});

					itemSelectorDialog.open();
				});
			},

			/**
    * Updates the link in the editor element. If the element didn't exist previously, it will
    * create a new <a> element with the href specified in the link input.
    *
    * @protected
    * @method _updateLink
    * @param {String} linkHref href value for the link
    * @param {String} linkTarget target value for the link
    */
			_updateLink: function _updateLink(linkHref, linkTarget) {
				var editor = this.props.editor.get('nativeEditor');
				var linkUtils = new CKEDITOR.Link(editor, { appendProtocol: false });
				var linkAttrs = {
					target: linkTarget
				};
				var modifySelection = { advance: true };

				if (linkHref) {
					if (this.state.element) {
						linkAttrs.href = linkHref;

						linkUtils.update(linkAttrs, this.state.element, modifySelection);
					} else {
						linkUtils.create(linkHref, linkAttrs, modifySelection);
					}

					editor.fire('actionPerformed', this);
				}
			}
		});

		AlloyEditor.Buttons[ButtonLinkEditBrowse.key] = AlloyEditor.ButtonLinkEditBrowse = ButtonLinkEditBrowse;
	})();
}).call(this);
}).call(this);
//# sourceMappingURL=buttons.js.map
