/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.alloyeditor.link.browse.web.internal.editor.configuration;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.file.criterion.FileItemSelectorCriterion;
import com.liferay.layout.item.selector.criterion.LayoutItemSelectorCriterion;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"editor.name=alloyeditor", "editor.name=alloyeditor_bbcode", "editor.name=alloyeditor_creole", "service.ranking:Integer=1000"}, service={EditorConfigContributor.class})
public class AlloyEditorLinkBrowseConfigContributor
extends BaseEditorConfigContributor {
    private ItemSelector _itemSelector;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        JSONArray selectionsJSONArray;
        JSONObject stylesJSONObject;
        JSONObject toolbarsJSONObject;
        JSONObject buttonCfgJSONObject = jsonObject.getJSONObject("buttonCfg");
        if (buttonCfgJSONObject != null) {
            jsonObject.put("buttonCfg", this.updateButtonCfgJSONObject(buttonCfgJSONObject));
        }
        if ((toolbarsJSONObject = jsonObject.getJSONObject("toolbars")) == null) {
            toolbarsJSONObject = JSONFactoryUtil.createJSONObject();
        }
        if ((stylesJSONObject = toolbarsJSONObject.getJSONObject("styles")) == null) {
            stylesJSONObject = JSONFactoryUtil.createJSONObject();
        }
        if ((selectionsJSONArray = stylesJSONObject.getJSONArray("selections")) != null) {
            for (int i = 0; i < selectionsJSONArray.length(); ++i) {
                JSONObject selectionJSONObject = selectionsJSONArray.getJSONObject(i);
                String name = selectionJSONObject.getString("name");
                if (!name.equals("text") && !name.equals("link")) continue;
                JSONArray buttonsJSONArray = selectionJSONObject.getJSONArray("buttons");
                selectionJSONObject.put("buttons", this.updateButtonsJSONArray(buttonsJSONArray));
            }
            stylesJSONObject.put("selections", selectionsJSONArray);
        }
        toolbarsJSONObject.put("styles", stylesJSONObject);
        jsonObject.put("toolbars", toolbarsJSONObject);
        String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        this.populateFileBrowserURL(jsonObject, requestBackedPortletURLFactory, namespace + name + "selectDocument");
    }

    protected void populateFileBrowserURL(JSONObject jsonObject, RequestBackedPortletURLFactory requestBackedPortletURLFactory, String eventName) {
        ArrayList<URLItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<URLItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new URLItemSelectorReturnType());
        FileItemSelectorCriterion fileItemSelectorCriterion = new FileItemSelectorCriterion();
        fileItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        LayoutItemSelectorCriterion layoutItemSelectorCriterion = new LayoutItemSelectorCriterion();
        layoutItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, eventName, new ItemSelectorCriterion[]{fileItemSelectorCriterion, layoutItemSelectorCriterion});
        jsonObject.put("documentBrowseLinkUrl", itemSelectorURL.toString());
    }

    @Reference(unbind="-")
    protected void setItemSelector(ItemSelector itemSelector) {
        this._itemSelector = itemSelector;
    }

    protected JSONObject updateButtonCfgJSONObject(JSONObject oldButtonCfgJSONObject) {
        Iterator buttonNames = oldButtonCfgJSONObject.keys();
        JSONObject newButtonCfgJSONObject = JSONFactoryUtil.createJSONObject();
        while (buttonNames.hasNext()) {
            String buttonName = (String)buttonNames.next();
            if (buttonName.equals("link")) {
                newButtonCfgJSONObject.put("linkBrowse", oldButtonCfgJSONObject.getJSONObject(buttonName));
                continue;
            }
            if (buttonName.equals("linkEdit")) {
                newButtonCfgJSONObject.put("linkEditBrowse", oldButtonCfgJSONObject.getJSONObject(buttonName));
                continue;
            }
            newButtonCfgJSONObject.put(buttonName, oldButtonCfgJSONObject.getJSONObject(buttonName));
        }
        return newButtonCfgJSONObject;
    }

    protected void updateButtonJSONObject(JSONArray buttonsJSONArray, JSONObject buttonJSONObject, String buttonName) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject cfgJSONObject = buttonJSONObject.getJSONObject("cfg");
        if (cfgJSONObject != null) {
            jsonObject.put("cfg", cfgJSONObject);
        }
        jsonObject.put("name", buttonName);
        buttonsJSONArray.put(jsonObject);
    }

    protected JSONArray updateButtonsJSONArray(JSONArray oldButtonsJSONArray) {
        JSONArray newButtonsJSONArray = JSONFactoryUtil.createJSONArray();
        for (int i = 0; i < oldButtonsJSONArray.length(); ++i) {
            String buttonName;
            JSONObject oldButtonJSONObject = oldButtonsJSONArray.getJSONObject(i);
            if (oldButtonJSONObject == null) {
                buttonName = oldButtonsJSONArray.getString(i);
                if (buttonName.equals("link")) {
                    newButtonsJSONArray.put("linkBrowse");
                    continue;
                }
                if (buttonName.equals("linkEdit")) {
                    newButtonsJSONArray.put("linkEditBrowse");
                    continue;
                }
                newButtonsJSONArray.put(buttonName);
                continue;
            }
            buttonName = oldButtonJSONObject.getString("name");
            if (buttonName.equals("link")) {
                this.updateButtonJSONObject(newButtonsJSONArray, oldButtonJSONObject, "linkBrowse");
                continue;
            }
            if (buttonName.equals("linkEdit")) {
                this.updateButtonJSONObject(newButtonsJSONArray, oldButtonJSONObject, "linkEditBrowse");
                continue;
            }
            newButtonsJSONArray.put(oldButtonJSONObject);
        }
        return newButtonsJSONArray;
    }
}

