/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.view.table;

import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.frontend.data.set.view.FDSViewContextContributor;
import com.liferay.frontend.data.set.view.table.BaseTableFDSView;
import com.liferay.frontend.data.set.view.table.FDSTableSchema;
import com.liferay.frontend.data.set.view.table.FDSTableSchemaField;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"frontend.data.set.view.name=table"}, service={FDSViewContextContributor.class})
public class TableFDSViewContextContributor
implements FDSViewContextContributor {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public Map<String, Object> getFDSViewContext(FDSView fdsView, Locale locale) {
        if (fdsView instanceof BaseTableFDSView) {
            return this._serialize((BaseTableFDSView)fdsView, locale);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> _serialize(BaseTableFDSView baseTableFDSView, Locale locale) {
        JSONArray fieldsJSONArray = this._jsonFactory.createJSONArray();
        FDSTableSchema fdsTableSchema = baseTableFDSView.getFDSTableSchema(locale);
        Map fieldsMap = fdsTableSchema.getFDSTableSchemaFieldsMap();
        ResourceBundle resourceBundle = baseTableFDSView.getResourceBundle(locale);
        for (FDSTableSchemaField fdsTableSchemaField : fieldsMap.values()) {
            String label = fdsTableSchemaField.getLabel();
            if (fdsTableSchemaField.isLocalizeLabel()) {
                label = this._language.get(resourceBundle, fdsTableSchemaField.getLabel());
            }
            if (Validator.isNull((String)label)) {
                label = "";
            }
            JSONObject fdsTableSchemaFieldJSONObject = fdsTableSchemaField.toJSONObject();
            fieldsJSONArray.put(fdsTableSchemaFieldJSONObject.put("label", label));
        }
        return HashMapBuilder.put((Object)"quickActionsEnabled", (Object)baseTableFDSView.isQuickActionsEnabled()).put((Object)"schema", (Object)JSONUtil.put((String)"fields", (Object)fieldsJSONArray)).build();
    }
}

