/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.css.rtl.servlet.internal;

import com.liferay.frontend.css.rtl.servlet.internal.converter.CSSRTLConverter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.RequestDispatcherUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.context.ServletContextHelper;

public class RTLServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(RTLServlet.class);
    private final Bundle _bundle;
    private final ServletContextHelper _servletContextHelper;

    public RTLServlet(Bundle bundle, ServletContextHelper servletContextHelper) {
        this._bundle = bundle;
        this._servletContextHelper = servletContextHelper;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        URL url = this.getResourceURL(httpServletRequest);
        if (url == null) {
            httpServletResponse.sendError(404, "Not Found");
        } else {
            this.transfer(url, httpServletResponse);
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        try {
            URL url = this.getResourceURL(httpServletRequest);
            if (url != null) {
                URLConnection urlConnection = url.openConnection();
                return urlConnection.getLastModified();
            }
            return super.getLastModified(httpServletRequest);
        }
        catch (IOException ioe) {
            return super.getLastModified(httpServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResourceURL(HttpServletRequest httpServletRequest) throws IOException {
        String path = URLDecoder.decode(RequestDispatcherUtil.getEffectivePath((HttpServletRequest)httpServletRequest), "UTF-8");
        URL url = this._servletContextHelper.getResource(path);
        if (url == null) {
            return null;
        }
        String languageId = httpServletRequest.getParameter("languageId");
        if (languageId == null || !PortalUtil.isRightToLeft((HttpServletRequest)httpServletRequest)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skip because specified language " + languageId + " is not right to left"));
            }
            return url;
        }
        String rtlPath = FileUtil.appendSuffix((String)path, (String)"_rtl");
        URL rtlURL = this._servletContextHelper.getResource(rtlPath);
        if (rtlURL != null) {
            return rtlURL;
        }
        File dataFile = this._bundle.getDataFile(rtlPath);
        if (dataFile.exists()) {
            URLConnection urlConnection = url.openConnection();
            if (dataFile.lastModified() > urlConnection.getLastModified()) {
                URI uri = dataFile.toURI();
                return uri.toURL();
            }
        }
        CSSRTLConverter cssRTLConverter = new CSSRTLConverter(false);
        String rtl = cssRTLConverter.process(StringUtil.read((InputStream)url.openStream()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rtl.getBytes("UTF-8"));
        try (OutputStream outputStream = null;){
            File parentFile = dataFile.getParentFile();
            parentFile.mkdirs();
            dataFile.createNewFile();
            outputStream = new FileOutputStream(dataFile);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream, (boolean)false);
        }
        ((InputStream)inputStream).reset();
        URI uri = dataFile.toURI();
        return uri.toURL();
    }

    protected void transfer(URL url, HttpServletResponse httpServletResponse) throws IOException {
        URLConnection urlConnection = url.openConnection();
        httpServletResponse.setContentLength(urlConnection.getContentLength());
        httpServletResponse.setContentType("text/css");
        httpServletResponse.setStatus(200);
        StreamUtil.transfer((InputStream)url.openStream(), (OutputStream)httpServletResponse.getOutputStream());
    }
}

