/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.compatibility.ie.servlet.filter;

import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"servlet-context-name=", "servlet-filter-name=IE MimeType Compatibility Filter", "url-pattern=/*"}, service={Filter.class})
public class IEMimeTypeCompatibilityFilter
extends BasePortalFilter {
    @Reference
    private BrowserSniffer _browserSniffer;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this._browserSniffer.isIe(httpServletRequest);
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        this.processFilter(IEMimeTypeCompatibilityFilter.class.getName(), httpServletRequest, (HttpServletResponse)new IEMimeTypeCompatibilityResponseWrapper(httpServletResponse), filterChain);
    }

    private static class IEMimeTypeCompatibilityResponseWrapper
    extends HttpServletResponseWrapper {
        public void setContentType(String contentType) {
            if (contentType.equals("image/x-ms-bmp")) {
                contentType = "image/bmp";
            }
            super.setContentType(contentType);
        }

        private IEMimeTypeCompatibilityResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }
    }
}

