/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.compatibility.ie.servlet.filter;

import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"servlet-context-name=", "servlet-filter-name=IE MimeType Compatibility Filter", "url-pattern=/*"}, service={Filter.class})
public class IEMimeTypeCompatibilityFilter
extends BasePortalFilter {
    @Reference
    private BrowserSniffer _browserSniffer;

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this._browserSniffer.isIe(request);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        this.processFilter(IEMimeTypeCompatibilityFilter.class.getName(), request, (HttpServletResponse)new IEMimeTypeCompatibilityResponseWrapper(response), filterChain);
    }

    private static class IEMimeTypeCompatibilityResponseWrapper
    extends HttpServletResponseWrapper {
        public void setContentType(String contentType) {
            if (contentType.equals("image/x-ms-bmp")) {
                contentType = "image/bmp";
            }
            super.setContentType(contentType);
        }

        private IEMimeTypeCompatibilityResponseWrapper(HttpServletResponse response) {
            super(response);
        }
    }
}

