/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.util.configuration;

import com.liferay.fragment.constants.FragmentConfigurationFieldDataType;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.frontend.token.definition.FrontendToken;
import com.liferay.frontend.token.definition.FrontendTokenDefinition;
import com.liferay.frontend.token.definition.FrontendTokenDefinitionRegistry;
import com.liferay.frontend.token.definition.FrontendTokenMapping;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.list.retriever.DefaultLayoutListRetrieverContext;
import com.liferay.layout.list.retriever.LayoutListRetriever;
import com.liferay.layout.list.retriever.LayoutListRetrieverContext;
import com.liferay.layout.list.retriever.LayoutListRetrieverRegistry;
import com.liferay.layout.list.retriever.ListObjectReferenceFactory;
import com.liferay.layout.list.retriever.ListObjectReferenceFactoryRegistry;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryConfigurationParser.class})
public class FragmentEntryConfigurationParserImpl
implements FragmentEntryConfigurationParser {
    private static final String _CONTEXT_OBJECT_LIST_SUFFIX = "ObjectList";
    private static final String _CONTEXT_OBJECT_SUFFIX = "Object";
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryConfigurationParserImpl.class);
    @Reference
    private FrontendTokenDefinitionRegistry _frontendTokenDefinitionRegistry;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutListRetrieverRegistry _layoutListRetrieverRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private ListObjectReferenceFactoryRegistry _listObjectReferenceFactoryRegistry;
    @Reference
    private Portal _portal;

    public JSONObject getConfigurationDefaultValuesJSONObject(String configuration) {
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        JSONObject defaultValuesJSONObject = this._jsonFactory.createJSONObject();
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            defaultValuesJSONObject.put(fragmentConfigurationField.getName(), this.getFieldValue(fragmentConfigurationField, LocaleUtil.getMostRelevantLocale(), null));
        }
        return defaultValuesJSONObject;
    }

    public Object getConfigurationFieldValue(String editableValues, String fieldName, FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType) {
        try {
            JSONObject editableValuesJSONObject = this._jsonFactory.createJSONObject(editableValues);
            JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
            if (configurationValuesJSONObject == null) {
                return null;
            }
            return this._getFieldValue(fragmentConfigurationFieldDataType, configurationValuesJSONObject.getString(fieldName));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse configuration JSON: " + editableValues), (Throwable)jsonException);
            }
            return null;
        }
    }

    public JSONObject getConfigurationJSONObject(String configuration, String editableValues, Locale locale) throws JSONException {
        JSONObject configurationDefaultValuesJSONObject = this.getConfigurationDefaultValuesJSONObject(configuration);
        if (configurationDefaultValuesJSONObject == null) {
            return this._jsonFactory.createJSONObject();
        }
        JSONObject editableValuesJSONObject = this._jsonFactory.createJSONObject(editableValues);
        JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
        if (configurationValuesJSONObject == null) {
            return configurationDefaultValuesJSONObject;
        }
        List<FragmentConfigurationField> configurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField configurationField : configurationFields) {
            String name = configurationField.getName();
            Object object = configurationValuesJSONObject.get(name);
            if (object == null) continue;
            configurationDefaultValuesJSONObject.put(name, this.getFieldValue(configurationField, locale, configurationValuesJSONObject.getString(name)));
        }
        return configurationDefaultValuesJSONObject;
    }

    public Map<String, Object> getContextObjects(JSONObject configurationValuesJSONObject, String configuration, Object displayObject, long[] segmentsEntryIds) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            Object contextListObject;
            String name = fragmentConfigurationField.getName();
            if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"itemSelector")) {
                Object contextObject = displayObject;
                if (displayObject == null) {
                    contextObject = this._getInfoDisplayObjectEntry(configurationValuesJSONObject.getString(name));
                }
                if (contextObject == null) continue;
                contextObjects.put(name + _CONTEXT_OBJECT_SUFFIX, contextObject);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"collectionSelector") || (contextListObject = this._getInfoListObjectEntry(configurationValuesJSONObject.getString(name), segmentsEntryIds)) == null) continue;
            contextObjects.put(name + _CONTEXT_OBJECT_LIST_SUFFIX, contextListObject);
        }
        return contextObjects;
    }

    public Object getFieldValue(FragmentConfigurationField fragmentConfigurationField, Locale locale, String value) {
        return this._getFieldValue(fragmentConfigurationField, locale, value);
    }

    public Object getFieldValue(String editableValues, FragmentConfigurationField fragmentConfigurationField, Locale locale) {
        try {
            JSONObject editableValuesJSONObject = this._jsonFactory.createJSONObject(editableValues);
            JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
            if (configurationValuesJSONObject == null) {
                return fragmentConfigurationField.getDefaultValue();
            }
            return this.getFieldValue(fragmentConfigurationField, locale, configurationValuesJSONObject.getString(fragmentConfigurationField.getName(), null));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return fragmentConfigurationField.getDefaultValue();
        }
    }

    public Object getFieldValue(String configuration, String editableValues, Locale locale, String name) {
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = this._jsonFactory.createJSONObject(editableValues);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
        JSONObject configurationValuesJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
        if (configurationValuesJSONObject == null) {
            return null;
        }
        List<FragmentConfigurationField> fragmentConfigurationFields = this.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            if (!Objects.equals(fragmentConfigurationField.getName(), name)) continue;
            return this.getFieldValue(fragmentConfigurationField, locale, configurationValuesJSONObject.getString(name));
        }
        return null;
    }

    public List<FragmentConfigurationField> getFragmentConfigurationFields(String configuration) {
        JSONArray fieldSetsJSONArray = this._getFieldSetsJSONArray(configuration);
        if (fieldSetsJSONArray == null) {
            return Collections.emptyList();
        }
        ArrayList<FragmentConfigurationField> fragmentConfigurationFields = new ArrayList<FragmentConfigurationField>();
        Iterator iterator1 = fieldSetsJSONArray.iterator();
        iterator1.forEachRemaining(fieldSetJSONObject -> {
            JSONArray fieldSetFieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            Iterator iterator2 = fieldSetFieldsJSONArray.iterator();
            iterator2.forEachRemaining(fieldSetFieldsJSONObject -> fragmentConfigurationFields.add(new FragmentConfigurationField(fieldSetFieldsJSONObject)));
        });
        return fragmentConfigurationFields;
    }

    public String translateConfiguration(JSONObject jsonObject, ResourceBundle resourceBundle) {
        JSONArray fieldSetsJSONArray = jsonObject.getJSONArray("fieldSets");
        if (fieldSetsJSONArray == null) {
            return "";
        }
        Iterator iterator = fieldSetsJSONArray.iterator();
        iterator.forEachRemaining(fieldSetJSONObject -> {
            String fieldSetLabel = fieldSetJSONObject.getString("label");
            fieldSetJSONObject.put("label", this._language.get(resourceBundle, fieldSetLabel, fieldSetLabel));
            JSONArray fieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            Iterator fieldsIterator = fieldsJSONArray.iterator();
            fieldsIterator.forEachRemaining(fieldJSONObject -> this._translateConfigurationField((JSONObject)fieldJSONObject, resourceBundle));
        });
        return jsonObject.toString();
    }

    private String _getColorPickerCssVariable(String fieldValue) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || Validator.isNull((String)fieldValue)) {
            return fieldValue;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        Group group = themeDisplay.getScopeGroup();
        LayoutSet layoutSet = this._layoutSetLocalService.fetchLayoutSet(themeDisplay.getSiteGroupId(), group.isLayoutSetPrototype());
        FrontendTokenDefinition frontendTokenDefinition = this._frontendTokenDefinitionRegistry.getFrontendTokenDefinition(layoutSet.getThemeId());
        if (frontendTokenDefinition == null) {
            return fieldValue;
        }
        Collection frontendTokens = frontendTokenDefinition.getFrontendTokens();
        for (FrontendToken frontendToken : frontendTokens) {
            JSONObject jsonObject = frontendToken.getJSONObject(LocaleUtil.getMostRelevantLocale());
            if (!Objects.equals(jsonObject.getString("name"), fieldValue)) continue;
            ArrayList frontendTokenMappings = new ArrayList(frontendToken.getFrontendTokenMappings("cssVariable"));
            if (frontendTokenMappings.isEmpty()) {
                return fieldValue;
            }
            FrontendTokenMapping frontendTokenMapping = (FrontendTokenMapping)frontendTokenMappings.get(0);
            return "var(--" + frontendTokenMapping.getValue() + ")";
        }
        return fieldValue;
    }

    private JSONArray _getFieldSetsJSONArray(String configuration) {
        try {
            JSONObject configurationJSONObject = this._jsonFactory.createJSONObject(configuration);
            return configurationJSONObject.getJSONArray("fieldSets");
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse configuration JSON: " + configuration), (Throwable)jsonException);
            }
            return null;
        }
    }

    private Object _getFieldValue(FragmentConfigurationField fragmentConfigurationField, Locale locale, String value) {
        String parsedValue = GetterUtil.getString((String)value);
        if (fragmentConfigurationField.isLocalizable() && JSONUtil.isValid((String)parsedValue)) {
            try {
                JSONObject valueJSONObject = this._jsonFactory.createJSONObject(parsedValue);
                parsedValue = valueJSONObject.getString(LocaleUtil.toLanguageId((Locale)locale), valueJSONObject.getString(LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), fragmentConfigurationField.getDefaultValue()));
            }
            catch (JSONException jsonException) {
                _log.error((Object)"Unable to parse configuration value JSON", (Throwable)jsonException);
            }
        } else if (value == null) {
            parsedValue = fragmentConfigurationField.getDefaultValue();
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"checkbox")) {
            return this._getFieldValue(FragmentConfigurationFieldDataType.BOOLEAN, parsedValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"collectionSelector")) {
            return this._getInfoListObjectEntryJSONObject(parsedValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"colorPalette")) {
            JSONObject jsonObject = (JSONObject)this._getFieldValue(FragmentConfigurationFieldDataType.OBJECT, parsedValue);
            if (jsonObject.isNull("color") && !jsonObject.isNull("cssClass")) {
                jsonObject.put("color", jsonObject.getString("cssClass"));
            }
            return jsonObject;
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"colorPicker")) {
            String fieldValue = (String)this._getFieldValue(FragmentConfigurationFieldDataType.STRING, parsedValue);
            return this._getColorPickerCssVariable(fieldValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"itemSelector")) {
            return this._getInfoDisplayObjectEntryJSONObject(parsedValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"length") || StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"select") || StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"text")) {
            FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType = fragmentConfigurationField.getFragmentConfigurationFieldDataType();
            if (fragmentConfigurationFieldDataType == null) {
                fragmentConfigurationFieldDataType = FragmentConfigurationFieldDataType.STRING;
            }
            return this._getFieldValue(fragmentConfigurationFieldDataType, parsedValue);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"url")) {
            return this._getURLValue(parsedValue);
        }
        return this._getFieldValue(FragmentConfigurationFieldDataType.STRING, parsedValue);
    }

    private Object _getFieldValue(FragmentConfigurationFieldDataType fragmentConfigurationFieldDataType, String value) {
        if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.ARRAY) {
            try {
                return this._jsonFactory.createJSONArray(value);
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to parse configuration JSON: " + value), (Throwable)jsonException);
                }
            }
        } else {
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.BOOLEAN) {
                return GetterUtil.getBoolean((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.DOUBLE) {
                return GetterUtil.getDouble((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.INTEGER) {
                return GetterUtil.getInteger((String)value);
            }
            if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.OBJECT) {
                try {
                    return this._jsonFactory.createJSONObject(value);
                }
                catch (JSONException jsonException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Unable to parse configuration JSON: " + value), (Throwable)jsonException);
                    }
                }
            } else if (fragmentConfigurationFieldDataType == FragmentConfigurationFieldDataType.STRING) {
                return value;
            }
        }
        return null;
    }

    private Object _getInfoDisplayObjectEntry(String value) {
        if (Validator.isNull((String)value)) {
            return null;
        }
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(value);
            String className = GetterUtil.getString((String)jsonObject.getString("className"));
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className);
            if (infoItemObjectProvider == null) {
                return null;
            }
            long classPK = GetterUtil.getLong((String)jsonObject.getString("classPK"));
            return infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get entry: " + value), (Throwable)exception);
            }
            return null;
        }
    }

    private JSONObject _getInfoDisplayObjectEntryJSONObject(String value) {
        try {
            if (Validator.isNull((String)value) || Objects.equals(value, this._jsonFactory.getNullJSON())) {
                return this._jsonFactory.createJSONObject();
            }
            JSONObject configurationValueJSONObject = this._jsonFactory.createJSONObject(value);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize(this._getInfoDisplayObjectEntry(value)));
            jsonObject.put("className", GetterUtil.getString((String)configurationValueJSONObject.getString("className"))).put("classNameId", GetterUtil.getString((String)configurationValueJSONObject.getString("classNameId"))).put("classPK", GetterUtil.getLong((String)configurationValueJSONObject.getString("classPK"))).put("template", configurationValueJSONObject.get("template")).put("title", configurationValueJSONObject.getString("title"));
            return jsonObject;
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize info display object entry to JSON: " + value), (Throwable)jsonException);
            }
            return null;
        }
    }

    private Object _getInfoListObjectEntry(String value, long[] segmentsEntryIds) {
        if (Validator.isNull((String)value)) {
            return Collections.emptyList();
        }
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(value);
            if (jsonObject.length() <= 0) {
                return Collections.emptyList();
            }
            String type = jsonObject.getString("type");
            LayoutListRetriever layoutListRetriever = this._layoutListRetrieverRegistry.getLayoutListRetriever(type);
            if (layoutListRetriever == null) {
                return Collections.emptyList();
            }
            ListObjectReferenceFactory listObjectReferenceFactory = this._listObjectReferenceFactoryRegistry.getListObjectReference(type);
            if (listObjectReferenceFactory == null) {
                return Collections.emptyList();
            }
            DefaultLayoutListRetrieverContext defaultLayoutListRetrieverContext = new DefaultLayoutListRetrieverContext();
            defaultLayoutListRetrieverContext.setSegmentsEntryIds(segmentsEntryIds);
            return layoutListRetriever.getList(listObjectReferenceFactory.getListObjectReference(jsonObject), (LayoutListRetrieverContext)defaultLayoutListRetrieverContext);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get collection: " + value), (Throwable)exception);
            }
            return Collections.emptyList();
        }
    }

    private JSONObject _getInfoListObjectEntryJSONObject(String value) {
        if (Validator.isNull((String)value)) {
            return this._jsonFactory.createJSONObject();
        }
        try {
            return this._jsonFactory.createJSONObject(value);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize info list object entry to JSON: " + value), (Throwable)jsonException);
            }
            return null;
        }
    }

    private Object _getURLValue(String value) {
        long layoutId;
        boolean privateLayout;
        JSONObject jsonObject = (JSONObject)this._getFieldValue(FragmentConfigurationFieldDataType.OBJECT, value);
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        if (layoutJSONObject == null) {
            return jsonObject.getString("href");
        }
        long groupId = layoutJSONObject.getLong("groupId");
        Layout layout = this._layoutLocalService.fetchLayout(groupId, privateLayout = layoutJSONObject.getBoolean("privateLayout"), layoutId = layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return "#";
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            return this._portal.getLayoutFullURL(layout, serviceContext.getThemeDisplay());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private void _translateConfigurationField(JSONObject fieldJSONObject, ResourceBundle resourceBundle) {
        JSONObject typeOptionsJSONObject;
        String fieldDescription = fieldJSONObject.getString("description");
        fieldJSONObject.put("description", this._language.get(resourceBundle, fieldDescription, fieldDescription));
        String fieldLabel = fieldJSONObject.getString("label");
        fieldJSONObject.put("label", this._language.get(resourceBundle, fieldLabel, fieldLabel));
        String type = fieldJSONObject.getString("type");
        if (!Objects.equals(type, "select") && !Objects.equals(type, "text")) {
            return;
        }
        if (fieldJSONObject.getBoolean("localizable")) {
            String defaultValue = fieldJSONObject.getString("defaultValue");
            fieldJSONObject.put("defaultValue", this._language.get(resourceBundle, defaultValue, defaultValue));
        }
        if ((typeOptionsJSONObject = fieldJSONObject.getJSONObject("typeOptions")) == null) {
            return;
        }
        if (Objects.equals(type, "select")) {
            JSONArray validValuesJSONArray = typeOptionsJSONObject.getJSONArray("validValues");
            Iterator validValuesIterator = validValuesJSONArray.iterator();
            validValuesIterator.forEachRemaining(validValueJSONObject -> {
                String value = validValueJSONObject.getString("value");
                String label = validValueJSONObject.getString("label", value);
                validValueJSONObject.put("label", this._language.get(resourceBundle, label, label));
            });
        } else {
            JSONObject validationJSONObject = typeOptionsJSONObject.getJSONObject("validation");
            if (validationJSONObject != null && validationJSONObject.has("errorMessage")) {
                String errorMessage = validationJSONObject.getString("errorMessage");
                validationJSONObject.put("errorMessage", this._language.get(resourceBundle, errorMessage, errorMessage));
            }
        }
    }
}

