/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentRendererUtil {
    private static final Log _log = LogFactoryUtil.getLog(FragmentRendererUtil.class);

    public static List<InfoItemRenderer<?>> getInfoItemRenderers(String className, Class<?> clazz, InfoItemRendererRegistry infoItemRendererRegistry) {
        Class<?> superClass;
        List infoItemRenderers;
        if (Validator.isNotNull((String)className) && !(infoItemRenderers = infoItemRendererRegistry.getInfoItemRenderers(className)).isEmpty()) {
            return infoItemRenderers;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length != 0) {
            for (Class<?> anInterface : interfaces) {
                List infoItemRenderers2 = infoItemRendererRegistry.getInfoItemRenderers(anInterface.getName());
                if (infoItemRenderers2.isEmpty()) continue;
                return infoItemRenderers2;
            }
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            return FragmentRendererUtil.getInfoItemRenderers(className, superClass, infoItemRendererRegistry);
        }
        return null;
    }

    public static boolean isEditMode(HttpServletRequest httpServletRequest) {
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
        String layoutMode = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"p_l_mode", (String)"view");
        return layoutMode.equals("edit");
    }

    public static void printPortletMessageInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String message) {
        block2: {
            try {
                PrintWriter printWriter = httpServletResponse.getWriter();
                StringBundler sb = new StringBundler(3);
                sb.append("<div class=\"portlet-msg-info\">");
                ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), FragmentRendererUtil.class);
                sb.append(LanguageUtil.get((ResourceBundle)resourceBundle, (String)message));
                sb.append("</div>");
                printWriter.write(sb.toString());
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)ioException);
            }
        }
    }
}

