/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.internal.renderer.FragmentRendererUtil;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemDetails;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererRegistry;
import com.liferay.info.item.renderer.InfoItemTemplatedRenderer;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class ContentObjectFragmentRenderer
implements FragmentRenderer {
    private static final Log _log = LogFactoryUtil.getLog(ContentObjectFragmentRenderer.class);
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private InfoItemRendererRegistry _infoItemRendererRegistry;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Language _language;

    public String getCollectionKey() {
        return "content-display";
    }

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        return JSONUtil.put((String)"fieldSets", (Object)JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"fields", (Object)JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"label", (Object)"item").put("name", "itemSelector").put("type", "itemSelector").put("typeOptions", JSONUtil.put((String)"enableSelectTemplate", (Object)true))}))})).toString();
    }

    public String getIcon() {
        return "web-content";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        return this._language.get(resourceBundle, "content-display");
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        JSONObject jsonObject = this._getFieldValueJSONObject(fragmentRendererContext);
        Optional contextInfoItemReferenceOptional = fragmentRendererContext.getContextInfoItemReferenceOptional();
        if (!(contextInfoItemReferenceOptional.isPresent() || jsonObject != null && jsonObject.length() != 0)) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "the-selected-content-will-be-shown-here");
            }
            return;
        }
        String className = "";
        Object displayObject = null;
        if (jsonObject != null) {
            className = jsonObject.getString("className");
            displayObject = this._getDisplayObject(className, jsonObject.getLong("classPK"), contextInfoItemReferenceOptional);
        } else {
            InfoItemReference infoItemReference = contextInfoItemReferenceOptional.orElse(null);
            displayObject = this._getInfoItem(infoItemReference);
        }
        if (displayObject == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "the-selected-content-is-no-longer-available.-please-select-another");
            }
            return;
        }
        Tuple tuple = this._getTuple(className, displayObject.getClass(), fragmentRendererContext);
        InfoItemRenderer infoItemRenderer = (InfoItemRenderer)tuple.getObject(0);
        if (infoItemRenderer == null) {
            if (FragmentRendererUtil.isEditMode(httpServletRequest)) {
                FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "there-are-no-available-renderers-for-the-selected-content");
            }
            return;
        }
        if (!this._hasPermission(httpServletRequest, className, displayObject)) {
            FragmentRendererUtil.printPortletMessageInfo(httpServletRequest, httpServletResponse, "you-do-not-have-permission-to-access-the-requested-resource");
            return;
        }
        if (infoItemRenderer instanceof InfoItemTemplatedRenderer) {
            InfoItemTemplatedRenderer infoItemTemplatedRenderer = (InfoItemTemplatedRenderer)infoItemRenderer;
            if (tuple.getSize() > 1) {
                infoItemTemplatedRenderer.render(displayObject, (String)tuple.getObject(1), httpServletRequest, httpServletResponse);
            } else {
                infoItemTemplatedRenderer.render(displayObject, httpServletRequest, httpServletResponse);
            }
        } else {
            infoItemRenderer.render(displayObject, httpServletRequest, httpServletResponse);
        }
    }

    private Object _getDisplayObject(String className, long classPK, Optional<InfoItemReference> infoItemReferenceOptional) {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        InfoItemReference infoItemReference = infoItemReferenceOptional.orElse(null);
        if (infoItemObjectProvider == null) {
            return this._getInfoItem(infoItemReference);
        }
        try {
            Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (infoItem == null) {
                return this._getInfoItem(infoItemReference);
            }
            return infoItem;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this._getInfoItem(infoItemReference);
        }
    }

    private JSONObject _getFieldValueJSONObject(FragmentRendererContext fragmentRendererContext) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        return (JSONObject)this._fragmentEntryConfigurationParser.getFieldValue(this.getConfiguration(fragmentRendererContext), fragmentEntryLink.getEditableValues(), fragmentRendererContext.getLocale(), "itemSelector");
    }

    private Object _getInfoItem(InfoItemReference infoItemReference) {
        if (infoItemReference == null) {
            return null;
        }
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, infoItemReference.getClassName(), infoItemIdentifier.getInfoItemServiceFilter());
        try {
            return infoItemObjectProvider.getInfoItem(infoItemIdentifier);
        }
        catch (NoSuchInfoItemException noSuchInfoItemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchInfoItemException);
            }
            return null;
        }
    }

    private Tuple _getTuple(String className, Class<?> displayObjectClass, FragmentRendererContext fragmentRendererContext) {
        List<InfoItemRenderer<?>> infoItemRenderers = FragmentRendererUtil.getInfoItemRenderers(className, displayObjectClass, this._infoItemRendererRegistry);
        if (infoItemRenderers == null) {
            return null;
        }
        InfoItemRenderer<?> defaultInfoItemRenderer = infoItemRenderers.get(0);
        JSONObject jsonObject = this._getFieldValueJSONObject(fragmentRendererContext);
        if (jsonObject == null) {
            return new Tuple(new Object[]{defaultInfoItemRenderer});
        }
        JSONObject templateJSONObject = jsonObject.getJSONObject("template");
        if (templateJSONObject == null) {
            return new Tuple(new Object[]{defaultInfoItemRenderer});
        }
        String infoItemRendererKey = templateJSONObject.getString("infoItemRendererKey");
        InfoItemRenderer infoItemRenderer = this._infoItemRendererRegistry.getInfoItemRenderer(infoItemRendererKey);
        if (infoItemRenderer != null) {
            return new Tuple(new Object[]{infoItemRenderer, templateJSONObject.getString("templateKey")});
        }
        return new Tuple(new Object[]{defaultInfoItemRenderer});
    }

    private boolean _hasPermission(HttpServletRequest httpServletRequest, String className, Object displayObject) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        InfoItemReference infoItemReference = (InfoItemReference)httpServletRequest.getAttribute("INFO_ITEM_REFERENCE");
        if (Validator.isNull((String)className) && Validator.isNotNull((String)infoItemReference.getClassName())) {
            className = infoItemReference.getClassName();
        }
        LayoutDisplayPageProvider layoutDisplayPageProvider = (LayoutDisplayPageProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_PROVIDER");
        if (Validator.isNull((String)className) && layoutDisplayPageProvider != null) {
            className = layoutDisplayPageProvider.getClassName();
        }
        InfoItemDetails infoItemDetails = (InfoItemDetails)httpServletRequest.getAttribute("INFO_ITEM_DETAILS");
        if (Validator.isNull((String)className) && infoItemDetails != null) {
            className = infoItemDetails.getClassName();
        }
        try {
            InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemPermissionProvider.class, className);
            if (infoItemPermissionProvider != null && !infoItemPermissionProvider.hasPermission(themeDisplay.getPermissionChecker(), displayObject, "VIEW")) {
                return false;
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to check display object permissions", (Throwable)exception);
            return false;
        }
        return true;
    }
}

