/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Tuple;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseContentFragmentRenderer
implements FragmentRenderer {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected FragmentEntryConfigurationParser fragmentEntryConfigurationParser;
    @Reference
    protected InfoItemServiceRegistry infoItemServiceRegistry;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseContentFragmentRenderer.class);

    protected Tuple getDisplayObject(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest) {
        AssetEntry assetEntry;
        FragmentEntryLink fragmentEntryLink;
        block8: {
            fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
            JSONObject jsonObject = (JSONObject)this.fragmentEntryConfigurationParser.getFieldValue(this.getConfiguration(fragmentRendererContext), fragmentEntryLink.getEditableValues(), fragmentRendererContext.getLocale(), "itemSelector");
            if (jsonObject != null && jsonObject.has("className") && jsonObject.has("classPK")) {
                return new Tuple(new Object[]{jsonObject.getString("className"), jsonObject.getLong("classPK")});
            }
            Optional contextInfoItemReferenceOptional = fragmentRendererContext.getContextInfoItemReferenceOptional();
            if (contextInfoItemReferenceOptional.isPresent()) {
                InfoItemReference infoItemReference = (InfoItemReference)contextInfoItemReferenceOptional.get();
                InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
                InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, infoItemReference.getClassName(), infoItemIdentifier.getInfoItemServiceFilter());
                try {
                    Object infoItem = infoItemObjectProvider.getInfoItem(infoItemIdentifier);
                    if (infoItem instanceof ClassedModel) {
                        ClassedModel classedModel = (ClassedModel)infoItem;
                        Serializable primaryKeyObj = classedModel.getPrimaryKeyObj();
                        if (!Objects.equals(classedModel.getModelClassName(), AssetEntry.class.getName())) {
                            return new Tuple(new Object[]{classedModel.getModelClassName(), primaryKeyObj});
                        }
                        AssetEntry assetEntry2 = this.assetEntryLocalService.fetchAssetEntry(((Long)primaryKeyObj).longValue());
                        if (assetEntry2 != null) {
                            return new Tuple(new Object[]{this.portal.getClassName(assetEntry2.getClassNameId()), assetEntry2.getClassPK()});
                        }
                    }
                }
                catch (NoSuchInfoItemException noSuchInfoItemException) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Throwable)noSuchInfoItemException);
                }
            }
        }
        if ((assetEntry = (AssetEntry)httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY")) != null) {
            return new Tuple(new Object[]{assetEntry.getClassName(), assetEntry.getClassPK()});
        }
        return new Tuple(new Object[]{fragmentEntryLink.getClassName(), fragmentEntryLink.getClassPK()});
    }
}

