/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.importer;

import com.liferay.fragment.configuration.FragmentServiceConfiguration;
import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.exception.DuplicateFragmentCollectionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentCompositionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentEntryKeyException;
import com.liferay.fragment.exception.FragmentCollectionNameException;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.fragment.importer.FragmentsImporterResultEntry;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.FragmentCompositionService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.FragmentEntryService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentsImporter.class})
public class FragmentsImporterImpl
implements FragmentsImporter {
    private static final String _FRAGMENT_COLLECTION_KEY_DEFAULT = "imported";
    private static final Log _log = LogFactoryUtil.getLog(FragmentsImporterImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentCompositionLocalService _fragmentCompositionLocalService;
    @Reference
    private FragmentCompositionService _fragmentCompositionService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryService _fragmentEntryService;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    private List<FragmentsImporterResultEntry> _fragmentsImporterResultEntries;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public List<FragmentsImporterResultEntry> importFragmentEntries(long userId, long groupId, long fragmentCollectionId, File file, boolean overwrite) throws Exception {
        this._fragmentsImporterResultEntries = new ArrayList<FragmentsImporterResultEntry>();
        try (ZipFile zipFile = new ZipFile(file);){
            HashMap<String, String> orphanFragmentCompositions = new HashMap<String, String>();
            HashMap<String, String> orphanFragmentEntries = new HashMap<String, String>();
            HashMap<String, String> resourceReferences = new HashMap<String, String>();
            Map<String, FragmentCollectionFolder> fragmentCollectionFolderMap = this._getFragmentCollectionFolderMap(zipFile, groupId, orphanFragmentCompositions, orphanFragmentEntries);
            for (Map.Entry<String, FragmentCollectionFolder> entry : fragmentCollectionFolderMap.entrySet()) {
                FragmentCollectionFolder fragmentCollectionFolder = entry.getValue();
                String name = entry.getKey();
                String description = "";
                String collectionJSON = this._getContent(zipFile, fragmentCollectionFolder.getFileName());
                if (Validator.isNotNull((String)collectionJSON)) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(collectionJSON);
                    name = jsonObject.getString("name");
                    description = jsonObject.getString("description");
                }
                if (Validator.isNull((String)name)) {
                    throw new FragmentCollectionNameException();
                }
                FragmentCollection fragmentCollection = this._addFragmentCollection(groupId, entry.getKey(), name, description, overwrite);
                this._importResources(userId, groupId, fragmentCollection, entry.getKey(), zipFile, resourceReferences);
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentCompositions(), overwrite);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentEntries(), resourceReferences, overwrite);
            }
            if (MapUtil.isNotEmpty(orphanFragmentCompositions) || MapUtil.isNotEmpty(orphanFragmentEntries)) {
                FragmentCollection fragmentCollection = this._fragmentCollectionService.fetchFragmentCollection(fragmentCollectionId);
                if (fragmentCollection == null) {
                    fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT);
                    if (fragmentCollection == null) {
                        Locale locale = this._portal.getSiteDefaultLocale(groupId);
                        fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, _FRAGMENT_COLLECTION_KEY_DEFAULT, this._language.get(locale, _FRAGMENT_COLLECTION_KEY_DEFAULT), "", ServiceContextThreadLocal.getServiceContext());
                    }
                    fragmentCollectionId = fragmentCollection.getFragmentCollectionId();
                }
                this._importFragmentCompositions(userId, groupId, zipFile, fragmentCollectionId, orphanFragmentCompositions, overwrite);
                this._importFragmentEntries(userId, groupId, zipFile, fragmentCollectionId, orphanFragmentEntries, resourceReferences, overwrite);
            }
        }
        return this._fragmentsImporterResultEntries;
    }

    private FragmentCollection _addFragmentCollection(long groupId, String fragmentCollectionKey, String name, String description, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, fragmentCollectionKey);
        if (fragmentCollection == null) {
            fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, fragmentCollectionKey, name, description, ServiceContextThreadLocal.getServiceContext());
        } else if (overwrite) {
            fragmentCollection = this._fragmentCollectionService.updateFragmentCollection(fragmentCollection.getFragmentCollectionId(), name, description);
        } else {
            throw new DuplicateFragmentCollectionKeyException(fragmentCollectionKey);
        }
        return fragmentCollection;
    }

    private FragmentEntry _addFragmentEntry(long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, boolean readOnly, String typeLabel, String typeOptions, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentCollection.getGroupId(), fragmentEntryKey);
        if (fragmentEntry != null && !overwrite) {
            throw new DuplicateFragmentEntryKeyException(fragmentEntryKey);
        }
        int type = FragmentConstants.getTypeFromLabel((String)StringUtil.toLowerCase((String)StringUtil.trim((String)typeLabel)));
        int status = 0;
        String errorMessage = null;
        try {
            this._fragmentEntryProcessorRegistry.validateFragmentEntryHTML(html, configuration);
            this._fragmentEntryValidator.validateConfiguration(configuration);
            this._fragmentEntryValidator.validateTypeOptions(type, typeOptions);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            if (type == 2) {
                this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, portalException.getMessage()));
                return null;
            }
            status = 2;
            errorMessage = portalException.getLocalizedMessage();
        }
        try {
            fragmentEntry = fragmentEntry == null ? this._fragmentEntryService.addFragmentEntry(fragmentCollection.getGroupId(), fragmentCollectionId, fragmentEntryKey, name, css, html, js, cacheable, configuration, icon, 0L, type, typeOptions, status, ServiceContextThreadLocal.getServiceContext()) : this._fragmentEntryService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), fragmentCollectionId, name, css, html, js, cacheable, configuration, icon, fragmentEntry.getPreviewFileEntryId(), typeOptions, status);
            if (fragmentEntry.isReadOnly() != readOnly) {
                fragmentEntry.setReadOnly(readOnly);
                fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
            }
            FragmentsImporterResultEntry.Status fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED;
            if (fragmentEntry.getStatus() == 2) {
                fragmentsImporterResultEntryStatus = FragmentsImporterResultEntry.Status.IMPORTED_DRAFT;
            }
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, fragmentsImporterResultEntryStatus, errorMessage));
            return fragmentEntry;
        }
        catch (PortalException portalException) {
            this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, portalException.getMessage()));
            return null;
        }
    }

    private void _addPortletFileEntries(long userId, long groupId, FragmentCollection fragmentCollection, ZipFile zipFile, Map<String, String> resourceReferences, Map<String, String> zipEntryNames, Repository repository) throws Exception {
        if (repository != null) {
            FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, fragmentCollection.getCompanyId());
            for (FileEntry fileEntry : PortletFileRepositoryUtil.getPortletFileEntries((long)groupId, (long)fragmentCollection.getResourcesFolderId())) {
                if (!zipEntryNames.containsKey(fileEntry.getFileName())) continue;
                if (fragmentServiceConfiguration.propagateChanges()) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
                    continue;
                }
                String newFileName = PortletFileRepositoryUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
                resourceReferences.put(fileEntry.getFileName(), newFileName);
                zipEntryNames.put(newFileName, zipEntryNames.get(fileEntry.getFileName()));
                zipEntryNames.remove(fileEntry.getFileName());
            }
        }
        for (Map.Entry<String, String> entry : zipEntryNames.entrySet()) {
            String fileName = entry.getKey();
            PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)fragmentCollection.getResourcesFolderId(), (InputStream)this._getInputStream(zipFile, entry.getValue()), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private void _addPortletFileEntriesWithFolders(long userId, long groupId, FragmentCollection fragmentCollection, ZipFile zipFile, Map<String, String> resourceReferences, Map<String, String> zipEntryNames, Repository repository) throws Exception {
        if (repository != null) {
            FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, fragmentCollection.getCompanyId());
            Map resources = fragmentCollection.getResourcesMap();
            for (Map.Entry entry : resources.entrySet()) {
                String fileEntryPath = (String)entry.getKey();
                if (!zipEntryNames.containsKey(fileEntryPath)) continue;
                FileEntry fileEntry = (FileEntry)entry.getValue();
                if (fragmentServiceConfiguration.propagateChanges()) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
                    continue;
                }
                String folderPath = "";
                int index = fileEntryPath.lastIndexOf("/");
                if (index != -1) {
                    folderPath = fileEntryPath.substring(0, index);
                }
                String newFileName = PortletFileRepositoryUtil.getUniqueFileName((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getFileName());
                resourceReferences.put(fileEntryPath, folderPath + newFileName);
                zipEntryNames.put(folderPath + newFileName, zipEntryNames.get(fileEntryPath));
                zipEntryNames.remove(fileEntryPath);
            }
        } else {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        HashMap folderIdsMap = HashMapBuilder.put((Object)"", (Object)fragmentCollection.getResourcesFolderId()).build();
        for (Map.Entry<String, String> entry : zipEntryNames.entrySet()) {
            String fileName = entry.getKey();
            String folderPath = "";
            int index = fileName.lastIndexOf("/");
            if (index != -1) {
                folderPath = fileName.substring(0, index);
                fileName = fileName.substring(index + 1);
            }
            PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)this._getOrCreateFolderId(folderIdsMap, folderPath, repository.getRepositoryId(), userId), (InputStream)this._getInputStream(zipFile, entry.getValue()), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private String _getContent(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return "";
        }
        return StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
    }

    private String _getFileName(String path) {
        int index = path.lastIndexOf(47);
        if (index > 0) {
            return path.substring(index + 1);
        }
        return path;
    }

    private String _getFilePath(String fragmentCollectionKey, String path) {
        path = StringUtil.removeFirst((String)path, (String)(fragmentCollectionKey + "/"));
        int index = path.indexOf("resources/");
        path = path.substring(index);
        return StringUtil.removeFirst((String)path, (String)"resources/");
    }

    private Map<String, FragmentCollectionFolder> _getFragmentCollectionFolderMap(ZipFile zipFile, long groupId, Map<String, String> orphanFragmentCompositions, Map<String, String> orphanFragmentEntries) throws Exception {
        String fileName;
        ZipEntry zipEntry;
        HashMap<String, FragmentCollectionFolder> fragmentCollectionFolderMap = new HashMap<String, FragmentCollectionFolder>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentCollection(fileName = zipEntry.getName())) continue;
            fragmentCollectionFolderMap.put(this._getKey(zipFile, groupId, fileName), new FragmentCollectionFolder(fileName));
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentComposition(fileName = zipEntry.getName()) && !this._isFragmentEntry(fileName)) continue;
            String fragmentCollectionPath = fileName;
            String fragmentCollectionKey = "";
            while (fragmentCollectionPath.length() > 0) {
                String fragmentCollectionFileName = (fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/") + 1)) + "collection.json";
                ZipEntry fragmentCollectionZipEntry = zipFile.getEntry(fragmentCollectionFileName);
                if (fragmentCollectionZipEntry != null) {
                    fragmentCollectionKey = this._getKey(zipFile, groupId, fragmentCollectionFileName);
                    break;
                }
                if (Validator.isNull((String)fragmentCollectionPath)) break;
                fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/"));
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (Validator.isNull((String)fragmentCollectionKey) && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            FragmentCollectionFolder fragmentCollectionFolder = (FragmentCollectionFolder)fragmentCollectionFolderMap.get(fragmentCollectionKey);
            if (fragmentCollectionFolder == null && this._isFragmentComposition(fileName)) {
                orphanFragmentCompositions.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (fragmentCollectionFolder == null && this._isFragmentEntry(fileName)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            if (this._isFragmentComposition(fileName)) {
                fragmentCollectionFolder.addFragmentComposition(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            fragmentCollectionFolder.addFragmentEntry(this._getKey(zipFile, groupId, fileName), fileName);
        }
        return fragmentCollectionFolderMap;
    }

    private String _getFragmentEntryContent(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return "";
        }
        return StringUtil.read((InputStream)inputStream);
    }

    private InputStream _getFragmentEntryInputStream(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        if (contentPath.startsWith("/")) {
            return this._getInputStream(zipFile, contentPath.substring(1));
        }
        if (contentPath.startsWith("./")) {
            contentPath = contentPath.substring(2);
        }
        String path = fileName.substring(0, fileName.lastIndexOf("/"));
        return this._getInputStream(zipFile, path + "/" + contentPath);
    }

    private InputStream _getInputStream(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    private String _getKey(ZipFile zipFile, long groupId, String fileName) throws Exception {
        String key = "";
        if (fileName.lastIndexOf(47) != -1) {
            String path = fileName.substring(0, fileName.lastIndexOf(47));
            key = path.substring(path.lastIndexOf(47) + 1);
        } else if (fileName.equals("collection.json")) {
            JSONObject collectionJSONObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentCollectionLocalService.generateFragmentCollectionKey(groupId, collectionJSONObject.getString("name"));
        } else if (fileName.equals("fragment.json")) {
            JSONObject fragmentJSONObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentEntryLocalService.generateFragmentEntryKey(groupId, fragmentJSONObject.getString("name"));
        }
        if (Validator.isNotNull((String)key)) {
            return key;
        }
        throw new IllegalArgumentException("Incorrect file name " + fileName);
    }

    private long _getOrCreateFolderId(Map<String, Long> folderIdsMap, String folderPath, long repositoryId, long userId) throws Exception {
        if (folderIdsMap.containsKey(folderPath)) {
            return folderIdsMap.get(folderPath);
        }
        String folderName = folderPath;
        String parentFolderPath = "";
        int index = folderName.lastIndexOf("/");
        if (index != -1) {
            folderName = folderName.substring(index + 1);
            parentFolderPath = folderPath.substring(0, index);
        }
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repositoryId, (long)this._getOrCreateFolderId(folderIdsMap, parentFolderPath, repositoryId, userId), (String)folderName, (ServiceContext)ServiceContextThreadLocal.getServiceContext());
        folderIdsMap.put(folderPath, folder.getFolderId());
        return folder.getFolderId();
    }

    private long _getPreviewFileEntryId(long userId, long groupId, ZipFile zipFile, String className, long classPK, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return 0L;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (repository == null) {
            if (groupId == 0L && Objects.equals(className, FragmentEntry.class.getName())) {
                FragmentEntry fragmentEntry = this._fragmentEntryLocalService.getFragmentEntry(classPK);
                Company company = this._companyLocalService.getCompany(fragmentEntry.getCompanyId());
                groupId = company.getGroupId();
            } else if (groupId == 0L && Objects.equals(className, FragmentComposition.class.getName())) {
                FragmentComposition fragmentComposition = this._fragmentCompositionLocalService.getFragmentComposition(classPK);
                Company company = this._companyLocalService.getCompany(fragmentComposition.getCompanyId());
                groupId = company.getGroupId();
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry(null, (long)groupId, (long)userId, (String)className, (long)classPK, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)repository.getDlFolderId(), (InputStream)inputStream, (String)(classPK + "_preview." + FileUtil.getExtension((String)contentPath)), (String)MimeTypesUtil.getContentType((String)contentPath), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private void _importFragmentCompositions(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentCompositions, boolean overwrite) throws Exception {
        for (Map.Entry<String, String> entry : fragmentCompositions.entrySet()) {
            String compositionJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNull((String)compositionJSON)) continue;
            JSONObject jsonObject = this._jsonFactory.createJSONObject(compositionJSON);
            String name = jsonObject.getString("name", entry.getKey());
            String description = jsonObject.getString("description");
            String definitionData = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject.getString("fragmentCompositionDefinitionPath"));
            FragmentComposition fragmentComposition = this._fragmentCompositionService.fetchFragmentComposition(groupId, entry.getKey());
            try {
                String thumbnailPath;
                if (fragmentComposition == null) {
                    fragmentComposition = this._fragmentCompositionService.addFragmentComposition(groupId, fragmentCollectionId, entry.getKey(), name, description, definitionData, 0L, 0, ServiceContextThreadLocal.getServiceContext());
                } else {
                    if (!overwrite) {
                        throw new DuplicateFragmentCompositionKeyException();
                    }
                    fragmentComposition = this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), fragmentCollectionId, name, description, definitionData, fragmentComposition.getPreviewFileEntryId(), fragmentComposition.getStatus());
                }
                if (fragmentComposition.getPreviewFileEntryId() > 0L) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentComposition.getPreviewFileEntryId());
                }
                if (!Validator.isNotNull((String)(thumbnailPath = jsonObject.getString("thumbnailPath")))) continue;
                this._fragmentCompositionService.updateFragmentComposition(fragmentComposition.getFragmentCompositionId(), this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentComposition.class.getName(), fragmentComposition.getFragmentCompositionId(), entry.getValue(), thumbnailPath));
            }
            catch (PortalException portalException) {
                this._fragmentsImporterResultEntries.add(new FragmentsImporterResultEntry(name, FragmentsImporterResultEntry.Status.INVALID, portalException.getMessage()));
            }
        }
    }

    private void _importFragmentEntries(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentEntries, Map<String, String> resourceReferences, boolean overwrite) throws Exception {
        for (Map.Entry<String, String> entry : fragmentEntries.entrySet()) {
            JSONObject jsonObject;
            String thumbnailPath;
            FragmentEntry fragmentEntry;
            String name = entry.getKey();
            String css = "";
            String html = "";
            String js = "";
            boolean cacheable = false;
            String configuration = "";
            String icon = "";
            boolean readOnly = false;
            String typeLabel = "";
            String typeOptions = "";
            String fragmentJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNotNull((String)fragmentJSON)) {
                JSONObject jsonObject2 = this._jsonFactory.createJSONObject(fragmentJSON);
                name = jsonObject2.getString("name");
                css = this._replaceResourceReferences(this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("cssPath")), resourceReferences);
                html = this._replaceResourceReferences(this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("htmlPath")), resourceReferences);
                js = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("jsPath"));
                cacheable = jsonObject2.getBoolean("cacheable");
                configuration = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("configurationPath"));
                readOnly = jsonObject2.getBoolean("readOnly");
                icon = jsonObject2.getString("icon");
                typeLabel = jsonObject2.getString("type");
                typeOptions = jsonObject2.getString("typeOptions");
            }
            if ((fragmentEntry = this._addFragmentEntry(fragmentCollectionId, entry.getKey(), name, css, html, js, cacheable, configuration, icon, readOnly, typeLabel, typeOptions, overwrite)) == null || !Validator.isNotNull((String)fragmentJSON)) continue;
            if (fragmentEntry.getPreviewFileEntryId() > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            }
            if (!Validator.isNotNull((String)(thumbnailPath = (jsonObject = this._jsonFactory.createJSONObject(fragmentJSON)).getString("thumbnailPath")))) continue;
            this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), this._getPreviewFileEntryId(userId, groupId, zipFile, FragmentEntry.class.getName(), fragmentEntry.getFragmentEntryId(), entry.getValue(), thumbnailPath));
        }
    }

    private void _importResources(long userId, long groupId, FragmentCollection fragmentCollection, String fragmentCollectionKey, ZipFile zipFile, Map<String, String> resourceReferences) throws Exception {
        if (groupId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Importing resources at the system level is not supported");
            }
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<? extends ZipEntry> zipEntries = Collections.list(enumeration);
        Stream stream = zipEntries.stream();
        Set excludePaths = stream.filter(zipEntry -> {
            String name = zipEntry.getName();
            return name.endsWith("collection.json") || name.endsWith("fragment.json");
        }).flatMap(zipEntry -> {
            String name = zipEntry.getName();
            String path = name.substring(0, name.lastIndexOf("/") + 1);
            if (name.endsWith("collection.json")) {
                return Arrays.stream(new String[]{name});
            }
            try {
                String fragmentJSON = StringUtil.read((InputStream)zipFile.getInputStream((ZipEntry)zipEntry));
                JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentJSON);
                return Arrays.stream(new String[]{path + "fragment.json", path + jsonObject.getString("configuration"), path + jsonObject.getString("cssPath"), path + jsonObject.getString("htmlPath"), path + jsonObject.getString("icon"), path + jsonObject.getString("jsPath"), path + jsonObject.getString("thumbnailPath")});
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to read fragments.json file " + name), (Throwable)exception);
                return Arrays.stream(new String[0]);
            }
        }).collect(Collectors.toSet());
        HashMap<String, String> zipEntryNames = new HashMap<String, String>();
        for (ZipEntry zipEntry2 : zipEntries) {
            Object[] paths = StringUtil.split((String)zipEntry2.getName(), (String)"/");
            String fileName = zipEntry2.getName();
            if (!ArrayUtil.contains((Object[])paths, (Object)"resources") || excludePaths.contains(zipEntry2.getName()) || !fileName.contains(fragmentCollectionKey) || fileName.endsWith("/")) continue;
            if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-158675"))) {
                zipEntryNames.put(this._getFilePath(fragmentCollectionKey, zipEntry2.getName()), zipEntry2.getName());
                continue;
            }
            zipEntryNames.put(this._getFileName(zipEntry2.getName()), zipEntry2.getName());
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-158675"))) {
            this._addPortletFileEntriesWithFolders(userId, groupId, fragmentCollection, zipFile, resourceReferences, zipEntryNames, repository);
        } else {
            this._addPortletFileEntries(userId, groupId, fragmentCollection, zipFile, resourceReferences, zipEntryNames, repository);
        }
    }

    private boolean _isFragmentCollection(String fileName) {
        return Objects.equals(this._getFileName(fileName), "collection.json");
    }

    private boolean _isFragmentComposition(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment-composition.json");
    }

    private boolean _isFragmentEntry(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment.json");
    }

    private String _replaceResourceReferences(String input, Map<String, String> replacedResourcesMap) {
        for (Map.Entry<String, String> replacedResource : replacedResourcesMap.entrySet()) {
            String source = "\\[resources:" + replacedResource.getKey() + "\\]";
            String target = "\\[resources:" + replacedResource.getValue() + "\\]";
            input = input.replaceAll(source, target);
        }
        return input;
    }

    private class FragmentCollectionFolder {
        private final String _fileName;
        private final Map<String, String> _fragmentCompositions = new HashMap<String, String>();
        private final Map<String, String> _fragmentEntries = new HashMap<String, String>();

        public FragmentCollectionFolder(String fileName) {
            this._fileName = fileName;
        }

        public void addFragmentComposition(String key, String fileName) {
            this._fragmentCompositions.put(key, fileName);
        }

        public void addFragmentEntry(String key, String fileName) {
            this._fragmentEntries.put(key, fileName);
        }

        public String getFileName() {
            return this._fileName;
        }

        public Map<String, String> getFragmentCompositions() {
            return this._fragmentCompositions;
        }

        public Map<String, String> getFragmentEntries() {
            return this._fragmentEntries;
        }
    }
}

