/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.contributor;

import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistration;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={FragmentCollectionContributorRegistry.class})
public class FragmentCollectionContributorRegistryImpl
implements FragmentCollectionContributorRegistry {
    @Reference
    protected FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry;
    @Reference
    protected FragmentEntryValidator fragmentEntryValidator;
    private static final int[] _SUPPORTED_FRAGMENT_TYPES = new int[]{1, 3, 0};
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionContributorRegistryImpl.class);
    private final Map<String, FragmentComposition> _fragmentCompositions = new ConcurrentHashMap<String, FragmentComposition>();
    private final Map<String, FragmentEntry> _fragmentEntries = new ConcurrentHashMap<String, FragmentEntry>();
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final Map<FragmentCollectionContributor, ServiceRegistration<?>> _serviceRegistrations = new HashMap();
    private ServiceTrackerMap<String, FragmentCollectionContributor> _serviceTrackerMap;

    public FragmentCollectionContributor getFragmentCollectionContributor(String fragmentCollectionKey) {
        return (FragmentCollectionContributor)this._serviceTrackerMap.getService((Object)fragmentCollectionKey);
    }

    public List<FragmentCollectionContributor> getFragmentCollectionContributors() {
        ArrayList<FragmentCollectionContributor> fragmentCollectionContributors = new ArrayList<FragmentCollectionContributor>();
        for (FragmentCollectionContributor fragmentCollectionContributor : this._serviceTrackerMap.values()) {
            if (!MapUtil.isNotEmpty((Map)fragmentCollectionContributor.getNames())) continue;
            fragmentCollectionContributors.add(fragmentCollectionContributor);
        }
        return fragmentCollectionContributors;
    }

    public FragmentComposition getFragmentComposition(String fragmentCompositionKey) {
        return this._fragmentCompositions.get(fragmentCompositionKey);
    }

    public Map<String, FragmentEntry> getFragmentEntries() {
        return new HashMap<String, FragmentEntry>(this._fragmentEntries);
    }

    public Map<String, FragmentEntry> getFragmentEntries(Locale locale) {
        HashMap<String, FragmentEntry> fragmentEntries = new HashMap<String, FragmentEntry>();
        for (FragmentCollectionContributor fragmentCollectionContributor : this._serviceTrackerMap.values()) {
            for (int type : _SUPPORTED_FRAGMENT_TYPES) {
                for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(type, locale)) {
                    fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
                }
            }
        }
        return fragmentEntries;
    }

    public FragmentEntry getFragmentEntry(String fragmentEntryKey) {
        if (fragmentEntryKey == null) {
            return null;
        }
        return this._fragmentEntries.get(fragmentEntryKey);
    }

    public ResourceBundleLoader getResourceBundleLoader() {
        ArrayList<ResourceBundleLoader> resourceBundleLoaders = new ArrayList<ResourceBundleLoader>();
        for (FragmentCollectionContributor fragmentCollectionContributor : this._serviceTrackerMap.values()) {
            ResourceBundleLoader resourceBundleLoader = fragmentCollectionContributor.getResourceBundleLoader();
            if (resourceBundleLoader == null) continue;
            resourceBundleLoaders.add(resourceBundleLoader);
        }
        return new AggregateResourceBundleLoader(resourceBundleLoaders.toArray(new ResourceBundleLoader[0]));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, FragmentCollectionContributor.class, (String)"fragment.collection.key", (ServiceTrackerCustomizer)new FragmentCollectionContributorRegistryServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _updateFragmentEntryLinks(FragmentEntry fragmentEntry) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(fragmentEntry.getFragmentEntryKey());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            try {
                this._fragmentEntryLinkLocalService.updateLatestChanges(fragmentEntry, fragmentEntryLink);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    private boolean _validateFragmentEntry(FragmentEntry fragmentEntry) {
        try {
            this.fragmentEntryValidator.validateConfiguration(fragmentEntry.getConfiguration());
            this.fragmentEntryValidator.validateTypeOptions(fragmentEntry.getType(), fragmentEntry.getTypeOptions());
            this.fragmentEntryProcessorRegistry.validateFragmentEntryHTML(fragmentEntry.getHtml(), fragmentEntry.getConfiguration());
            return true;
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to validate fragment entry", (Throwable)portalException);
            return false;
        }
    }

    private class FragmentCollectionContributorRegistryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FragmentCollectionContributor, FragmentCollectionContributor> {
        private final BundleContext _bundleContext;

        public FragmentCollectionContributor addingService(ServiceReference<FragmentCollectionContributor> serviceReference) {
            FragmentCollectionContributor fragmentCollectionContributor = (FragmentCollectionContributor)this._bundleContext.getService(serviceReference);
            for (FragmentComposition fragmentComposition : fragmentCollectionContributor.getFragmentCompositions()) {
                FragmentCollectionContributorRegistryImpl.this._fragmentCompositions.put(fragmentComposition.getFragmentCompositionKey(), fragmentComposition);
            }
            for (Object type : (Object)_SUPPORTED_FRAGMENT_TYPES) {
                for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries((int)type)) {
                    if (!FragmentCollectionContributorRegistryImpl.this._validateFragmentEntry(fragmentEntry)) continue;
                    FragmentCollectionContributorRegistryImpl.this._fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
                    FragmentCollectionContributorRegistryImpl.this._updateFragmentEntryLinks(fragmentEntry);
                }
            }
            FragmentCollectionContributorRegistryImpl.this._serviceRegistrations.put(fragmentCollectionContributor, this._bundleContext.registerService(FragmentCollectionContributorRegistration.class, (Object)new FragmentCollectionContributorRegistration(){}, MapUtil.singletonDictionary((Object)"fragment.collection.key", (Object)serviceReference.getProperty("fragment.collection.key"))));
            return fragmentCollectionContributor;
        }

        public void modifiedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionContributor fragmentCollectionContributor) {
        }

        public void removedService(ServiceReference<FragmentCollectionContributor> serviceReference, FragmentCollectionContributor fragmentCollectionContributor) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)FragmentCollectionContributorRegistryImpl.this._serviceRegistrations.remove(fragmentCollectionContributor);
            serviceRegistration.unregister();
            for (FragmentComposition fragmentComposition : fragmentCollectionContributor.getFragmentCompositions()) {
                FragmentCollectionContributorRegistryImpl.this._fragmentCompositions.remove(fragmentComposition.getFragmentCompositionKey());
            }
            for (Object type : (Object)_SUPPORTED_FRAGMENT_TYPES) {
                for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries((int)type)) {
                    FragmentCollectionContributorRegistryImpl.this._fragmentEntries.remove(fragmentEntry.getFragmentEntryKey());
                }
            }
            this._bundleContext.ungetService(serviceReference);
        }

        private FragmentCollectionContributorRegistryServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }
}

