/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererTracker;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentRendererUtil {
    private static final Log _log = LogFactoryUtil.getLog(FragmentRendererUtil.class);

    public static List<InfoItemRenderer<?>> getInfoItemRenderers(Class<?> clazz, InfoItemRendererTracker infoItemRendererTracker) {
        Class<?> superClass;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length != 0) {
            for (Class<?> anInterface : interfaces) {
                List infoItemRenderers = infoItemRendererTracker.getInfoItemRenderers(anInterface.getName());
                if (infoItemRenderers.isEmpty()) continue;
                return infoItemRenderers;
            }
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            return FragmentRendererUtil.getInfoItemRenderers(superClass, infoItemRendererTracker);
        }
        return null;
    }

    public static boolean isEditMode(HttpServletRequest httpServletRequest) {
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest);
        String layoutMode = ParamUtil.getString((HttpServletRequest)originalHttpServletRequest, (String)"p_l_mode", (String)"view");
        return layoutMode.equals("edit");
    }

    public static void printPortletMessageInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String message) {
        block2: {
            try {
                PrintWriter printWriter = httpServletResponse.getWriter();
                StringBundler sb = new StringBundler(3);
                sb.append("<div class=\"portlet-msg-info\">");
                ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), FragmentRendererUtil.class);
                sb.append(LanguageUtil.get((ResourceBundle)resourceBundle, (String)message));
                sb.append("</div>");
                printWriter.write(sb.toString());
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)ioException, (Throwable)ioException);
            }
        }
    }
}

