/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.layout.adaptive.media.LayoutAdaptiveMediaProcessor;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentRendererController.class})
public class FragmentRendererControllerImpl
implements FragmentRendererController {
    private static final Log _log = LogFactoryUtil.getLog(FragmentRendererControllerImpl.class);
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;
    @Reference
    private LayoutAdaptiveMediaProcessor _layoutAdaptiveMediaProcessor;

    public String getConfiguration(FragmentRendererContext fragmentRendererContext) {
        FragmentRenderer fragmentRenderer = this._getFragmentRenderer(fragmentRendererContext.getFragmentEntryLink());
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentRenderer.getConfiguration(fragmentRendererContext));
            return this._translateConfigurationFields(jsonObject, fragmentRendererContext.getLocale());
        }
        catch (JSONException jsonException) {
            _log.error((Object)"Unable to parse fragment entry link configuration", (Throwable)jsonException);
            return "";
        }
    }

    public String render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        FragmentRenderer fragmentRenderer = this._getFragmentRenderer(fragmentEntryLink);
        try {
            fragmentRenderer.render(fragmentRendererContext, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to render content of fragment entry ", fragmentEntryLink.getFragmentEntryId(), ":", exception.getMessage()}), (Throwable)exception);
            } else {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to render content of fragment entry ", fragmentEntryLink.getFragmentEntryId(), ":", exception.getMessage()}));
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)"fragmentEntryContentInvalid");
            return this._getFragmentEntryContentExceptionMessage(exception, httpServletRequest);
        }
        if (Objects.equals(fragmentRendererContext.getMode(), "EDIT")) {
            return this._layoutAdaptiveMediaProcessor.processAdaptiveMediaContent(unsyncStringWriter.toString());
        }
        return unsyncStringWriter.toString();
    }

    private String _getFragmentEntryContentExceptionMessage(Exception exception, HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(3);
        sb.append("<div class=\"alert alert-danger m-2\">");
        String errorMessage = "an-unexpected-error-occurred";
        Throwable throwable = exception.getCause();
        if (throwable instanceof FragmentEntryContentException) {
            FragmentEntryContentException fragmentEntryContentException = (FragmentEntryContentException)throwable;
            errorMessage = fragmentEntryContentException.getLocalizedMessage();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String localizedErrorMessage = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)errorMessage);
        sb.append(localizedErrorMessage.replaceAll("\\n", "<br>"));
        sb.append("</div>");
        return sb.toString();
    }

    private FragmentRenderer _getFragmentRenderer(FragmentEntryLink fragmentEntryLink) {
        FragmentEntry fragmentEntry;
        FragmentRenderer fragmentRenderer = null;
        if (Validator.isNotNull((String)fragmentEntryLink.getRendererKey())) {
            fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        }
        if (fragmentRenderer == null && (fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId())) != null && fragmentEntry.getType() == 2) {
            fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer("FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY_REACT");
        }
        if (fragmentRenderer == null) {
            fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer("FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY");
        }
        return fragmentRenderer;
    }

    private String _translateConfigurationFields(JSONObject jsonObject, Locale locale) {
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), this._fragmentCollectionContributorTracker.getResourceBundleLoader()});
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        return this._fragmentEntryConfigurationParser.translateConfiguration(jsonObject, resourceBundle);
    }
}

