/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.contributor.PortletAliasRegistration;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={PortletRegistry.class})
public class PortletRegistryImpl
implements PortletRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PortletRegistryImpl.class);
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    private final Map<String, String> _portletNames = new ConcurrentHashMap<String, String>();

    public List<String> getFragmentEntryLinkPortletIds(FragmentEntryLink fragmentEntryLink) {
        ArrayList<String> portletIds = new ArrayList<String>();
        Document document = Jsoup.parseBodyFragment((String)fragmentEntryLink.getHtml());
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        for (Element element : document.select("*")) {
            String alias;
            String portletName;
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-") || Validator.isNull((String)(portletName = this.getPortletName(alias = StringUtil.removeSubstring((String)tagName, (String)"lfr-widget-"))))) continue;
            String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)(fragmentEntryLink.getNamespace() + element.attr("id")));
            portletIds.add(portletId);
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
            String portletId = jsonObject.getString("portletId");
            if (Validator.isNotNull((String)portletId)) {
                String instanceId = jsonObject.getString("instanceId");
                portletIds.add(PortletIdCodec.encode((String)portletId, (String)instanceId));
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to get portlet IDs", (Throwable)portalException);
        }
        return portletIds;
    }

    public List<String> getPortletAliases() {
        return new ArrayList<String>(this._portletNames.keySet());
    }

    public String getPortletName(String alias) {
        return this._portletNames.get(alias);
    }

    public void writePortletPaths(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        List<String> fragmentEntryLinkPortletIds = this.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        if (ListUtil.isEmpty(fragmentEntryLinkPortletIds)) {
            return;
        }
        Stream stream = fragmentEntryLinkPortletIds.stream();
        List portlets = stream.map(fragmentEntryLinkPortletId -> this._portletLocalService.getPortletById(fragmentEntryLinkPortletId)).filter(portlet -> {
            if (portlet == null) {
                return false;
            }
            return portlet.isActive() && !portlet.isUndeployedPortlet();
        }).distinct().collect(Collectors.toList());
        for (Portlet portlet2 : portlets) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            try {
                PortletJSONUtil.populatePortletJSONObject((HttpServletRequest)httpServletRequest, (String)"", (Portlet)portlet2, (JSONObject)jsonObject);
                PortletJSONUtil.writeHeaderPaths((HttpServletResponse)httpServletResponse, (JSONObject)jsonObject);
                PortletJSONUtil.writeFooterPaths((HttpServletResponse)httpServletResponse, (JSONObject)jsonObject);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to write portlet paths " + portlet2.getPortletId()), (Throwable)exception);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(com.liferay.fragment.entry.processor.portlet.alias=*)")
    protected void setPortlet(javax.portlet.Portlet jxPortlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.put(alias, portletName);
        Bundle bundle = FrameworkUtil.getBundle(jxPortlet.getClass());
        BundleContext bundleContext = bundle.getBundleContext();
        HashMapDictionary aliasRegistrationProperties = new HashMapDictionary();
        aliasRegistrationProperties.put("com.liferay.fragment.entry.processor.portlet.alias", alias);
        bundleContext.registerService(PortletAliasRegistration.class, (Object)new PortletAliasRegistration(){}, (Dictionary)aliasRegistrationProperties);
    }

    protected void unsetPortlet(javax.portlet.Portlet jxPortlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.remove(alias, portletName);
    }
}

