/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.renderer.InfoItemRenderer;
import com.liferay.info.renderer.InfoItemRendererTracker;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class LayoutDisplayObjectFragmentRenderer
implements FragmentRenderer {
    private static final Log _log = LogFactoryUtil.getLog(LayoutDisplayObjectFragmentRenderer.class);
    @Reference
    private InfoItemRendererTracker _infoItemRendererTracker;

    public String getCollectionKey() {
        return "display-page";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"content");
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        return Objects.equals(layout.getType(), "asset_display");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object displayObject = this._getDisplayObject(httpServletRequest);
        if (displayObject == null) {
            StringBundler sb = new StringBundler(3);
            sb.append("<div class=\"portlet-msg-info\">");
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
            sb.append(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-rendered-content-will-be-shown-here"));
            sb.append("</div>");
            try {
                try {
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    printWriter.write(sb.toString());
                    return;
                }
                catch (IOException ioe) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)ioe, (Throwable)ioe);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        Class<?> displayObjectClass = displayObject.getClass();
        List<InfoItemRenderer> infoItemRenderers = this._getInfoItemRenderer(displayObjectClass);
        if (infoItemRenderers == null) {
            return;
        }
        InfoItemRenderer infoItemRenderer = infoItemRenderers.get(0);
        infoItemRenderer.render(displayObject, httpServletRequest, httpServletResponse);
    }

    private Object _getDisplayObject(HttpServletRequest httpServletRequest) {
        InfoDisplayObjectProvider infoDisplayObjectProvider = (InfoDisplayObjectProvider)httpServletRequest.getAttribute("INFO_DISPLAY_OBJECT_PROVIDER");
        if (infoDisplayObjectProvider == null) {
            return null;
        }
        return infoDisplayObjectProvider.getDisplayObject();
    }

    private List<InfoItemRenderer> _getInfoItemRenderer(Class<?> clazz) {
        Class<?> superclass;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length != 0) {
            for (Class<?> anInterface : interfaces) {
                List infoItemRenderers = this._infoItemRendererTracker.getInfoItemRenderers(anInterface.getName());
                if (infoItemRenderers.isEmpty()) continue;
                return infoItemRenderers;
            }
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            return this._getInfoItemRenderer(superclass);
        }
        return null;
    }
}

