/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={FragmentRendererTracker.class})
public class FragmentRendererTrackerImpl
implements FragmentRendererTracker {
    private final Map<String, FragmentRenderer> _fragmentRenderers = new ConcurrentHashMap<String, FragmentRenderer>();

    public FragmentRenderer getFragmentRenderer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return this._fragmentRenderers.get(key);
    }

    public List<FragmentRenderer> getFragmentRenderers() {
        return new ArrayList<FragmentRenderer>(this._fragmentRenderers.values());
    }

    public List<FragmentRenderer> getFragmentRenderers(int type) {
        Collection<FragmentRenderer> fragmentRenderers = this._fragmentRenderers.values();
        return fragmentRenderers.stream().filter(fragmentRenderer -> fragmentRenderer.getType() == type).collect(Collectors.toCollection(ArrayList::new));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setFragmentRenderer(FragmentRenderer fragmentRenderer) {
        this._fragmentRenderers.put(fragmentRenderer.getKey(), fragmentRenderer);
    }

    protected void unsetFragmentRenderer(FragmentRenderer fragmentRenderer) {
        this._fragmentRenderers.remove(fragmentRenderer.getKey());
    }
}

