/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentRendererController.class})
public class FragmentRendererControllerImpl
implements FragmentRendererController {
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;

    public String render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        FragmentRenderer fragmentRenderer = this._getFragmentRenderer(fragmentRendererContext.getFragmentEntryLink());
        try {
            fragmentRenderer.render(fragmentRendererContext, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        }
        catch (IOException ioe) {
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)"fragmentEntryInvalidContent");
            StringBundler sb = new StringBundler(3);
            sb.append("<div class=\"alert alert-danger m-2\">");
            String errorMessage = "an-unexpected-error-occurred";
            Throwable cause = ioe.getCause();
            if (cause instanceof FragmentEntryContentException) {
                FragmentEntryContentException fece = (FragmentEntryContentException)cause;
                errorMessage = fece.getLocalizedMessage();
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            sb.append(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)errorMessage));
            sb.append("</div>");
            return sb.toString();
        }
        return unsyncStringWriter.toString();
    }

    private FragmentRenderer _getFragmentRenderer(FragmentEntryLink fragmentEntryLink) {
        FragmentRenderer fragmentRenderer = null;
        if (Validator.isNotNull((String)fragmentEntryLink.getRendererKey())) {
            fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        }
        if (fragmentRenderer == null) {
            fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer("FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY");
        }
        return fragmentRenderer;
    }
}

