/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.renderer;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentRenderer.class})
public class FragmentEntryFragmentRenderer
implements FragmentRenderer {
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private PortletRegistry _portletRegistry;

    public String getCollectionKey() {
        return "";
    }

    public String getKey() {
        return "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY";
    }

    public boolean isSelectable(HttpServletRequest httpServletRequest) {
        return false;
    }

    public void render(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(this._renderFragmentEntryLink(fragmentRendererContext, httpServletRequest, httpServletResponse));
        }
        catch (PortalException pe) {
            throw new IOException(pe);
        }
    }

    private String _renderFragmentEntry(long fragmentEntryId, String css, String html, String js, String namespace) {
        StringBundler sb = new StringBundler(14);
        sb.append("<div id=\"");
        StringBundler fragmentIdSB = new StringBundler(4);
        fragmentIdSB.append("fragment-");
        fragmentIdSB.append(fragmentEntryId);
        fragmentIdSB.append("-");
        fragmentIdSB.append(namespace);
        sb.append(fragmentIdSB.toString());
        sb.append("\" >");
        sb.append(html);
        sb.append("</div>");
        if (Validator.isNotNull((String)css)) {
            sb.append("<style>");
            sb.append(css);
            sb.append("</style>");
        }
        if (Validator.isNotNull((String)js)) {
            sb.append("<script>(function() {");
            sb.append("var fragmentElement = document.querySelector('#");
            sb.append(fragmentIdSB.toString());
            sb.append("');");
            sb.append(js);
            sb.append(";}());</script>");
        }
        return sb.toString();
    }

    private String _renderFragmentEntryLink(FragmentRendererContext fragmentRendererContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        FragmentEntryLink fragmentEntryLink = fragmentRendererContext.getFragmentEntryLink();
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, fragmentRendererContext.getMode(), fragmentRendererContext.getLocale());
        Optional fieldValuesOptional = fragmentRendererContext.getFieldValuesOptional();
        defaultFragmentEntryProcessorContext.setFieldValues((Map)fieldValuesOptional.orElse(null));
        defaultFragmentEntryProcessorContext.setPreviewClassPK(fragmentRendererContext.getPreviewClassPK());
        defaultFragmentEntryProcessorContext.setPreviewType(fragmentRendererContext.getPreviewType());
        defaultFragmentEntryProcessorContext.setSegmentsExperienceIds(fragmentRendererContext.getSegmentsExperienceIds());
        String css = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkCSS(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        String html = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        html = this._writePortletPaths(fragmentEntryLink, html, httpServletRequest, httpServletResponse);
        return this._renderFragmentEntry(fragmentEntryLink.getFragmentEntryId(), css, html, fragmentEntryLink.getJs(), fragmentEntryLink.getNamespace());
    }

    private String _writePortletPaths(FragmentEntryLink fragmentEntryLink, String html, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this._portletRegistry.writePortletPaths(fragmentEntryLink, httpServletRequest, (HttpServletResponse)new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter));
        unsyncStringWriter.append((CharSequence)html);
        return unsyncStringWriter.toString();
    }
}

