/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletJSONUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={PortletRegistry.class})
public class PortletRegistryImpl
implements PortletRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PortletRegistryImpl.class);
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    private final Map<String, String> _portletNames = new ConcurrentHashMap<String, String>();
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public List<String> getFragmentEntryLinkPortletIds(FragmentEntryLink fragmentEntryLink) {
        ArrayList<String> portletIds = new ArrayList<String>();
        Document document = Jsoup.parseBodyFragment((String)fragmentEntryLink.getHtml());
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        for (Element element : document.select("*")) {
            String alias;
            String portletName;
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-") || Validator.isNull((String)(portletName = this.getPortletName(alias = StringUtil.replace((String)tagName, (String)"lfr-widget-", (String)""))))) continue;
            String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)(fragmentEntryLink.getNamespace() + element.attr("id")));
            portletIds.add(portletId);
        }
        return portletIds;
    }

    public List<String> getPortletAliases() {
        return new ArrayList<String>(this._portletNames.keySet());
    }

    public String getPortletName(String alias) {
        return this._portletNames.get(alias);
    }

    public void writePortletPaths(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        long plid = fragmentEntryLink.getClassPK();
        if (fragmentEntryLink.getClassNameId() == this._portal.getClassNameId(LayoutPageTemplateEntry.class)) {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntry(fragmentEntryLink.getClassPK());
            plid = layoutPageTemplateEntry.getPlid();
        }
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, plid);
        Stream stream = portletPreferencesList.stream();
        stream.map(portletPreferences -> this._portletLocalService.getPortletById(fragmentEntryLink.getCompanyId(), portletPreferences.getPortletId())).forEach(portlet -> {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            try {
                PortletJSONUtil.populatePortletJSONObject((HttpServletRequest)httpServletRequest, (String)"", (Portlet)portlet, (JSONObject)jsonObject);
                PortletJSONUtil.writeHeaderPaths((HttpServletResponse)httpServletResponse, (JSONObject)jsonObject);
                PortletJSONUtil.writeFooterPaths((HttpServletResponse)httpServletResponse, (JSONObject)jsonObject);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to write portlet paths " + portlet.getPortletId()), (Throwable)e);
            }
        });
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(com.liferay.fragment.entry.processor.portlet.alias=*)")
    protected void setPortlet(javax.portlet.Portlet portlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.put(alias, portletName);
    }

    protected void unsetPortlet(javax.portlet.Portlet portlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.remove(alias, portletName);
    }
}

