/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.importer;

import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.exception.DuplicateFragmentCollectionKeyException;
import com.liferay.fragment.exception.DuplicateFragmentEntryKeyException;
import com.liferay.fragment.exception.FragmentCollectionNameException;
import com.liferay.fragment.exception.InvalidFileException;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.FragmentEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentsImporter.class})
public class FragmentsImporterImpl
implements FragmentsImporter {
    private static final String _DEFAULT_FRAGMENT_COLLECTION_KEY = "imported";
    private static final Log _log = LogFactoryUtil.getLog(FragmentsImporterImpl.class);
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryService _fragmentEntryService;
    private List<String> _invalidFragmentEntriesNames;
    @Reference
    private Portal _portal;

    public List<String> importFile(long userId, long groupId, long fragmentCollectionId, File file, boolean overwrite) throws Exception {
        this._invalidFragmentEntriesNames = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(file);
        this._isValidFile(zipFile);
        HashMap<String, String> orphanFragmentEntries = new HashMap<String, String>();
        Map<String, FragmentCollectionFolder> fragmentCollectionFolderMap = this._getFragmentCollectionFolderMap(zipFile, groupId, orphanFragmentEntries);
        for (Map.Entry<String, FragmentCollectionFolder> entry : fragmentCollectionFolderMap.entrySet()) {
            FragmentCollectionFolder fragmentCollectionFolder = entry.getValue();
            String name = entry.getKey();
            String description = "";
            String collectionJSON = this._getContent(zipFile, fragmentCollectionFolder.getFileName());
            if (Validator.isNotNull((String)collectionJSON)) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)collectionJSON);
                name = jsonObject.getString("name");
                description = jsonObject.getString("description");
            }
            if (Validator.isNull((String)name)) {
                throw new FragmentCollectionNameException();
            }
            FragmentCollection fragmentCollection = this._addFragmentCollection(groupId, entry.getKey(), name, description, overwrite);
            this._importResources(userId, groupId, fragmentCollection.getFragmentCollectionId(), fragmentCollection.getResourcesFolderId(), zipFile);
            this._importFragmentEntries(userId, groupId, zipFile, fragmentCollection.getFragmentCollectionId(), fragmentCollectionFolder.getFragmentEntries(), overwrite);
        }
        if (MapUtil.isNotEmpty(orphanFragmentEntries)) {
            if (fragmentCollectionId <= 0L) {
                FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, _DEFAULT_FRAGMENT_COLLECTION_KEY);
                if (fragmentCollection == null) {
                    Locale locale = this._portal.getSiteDefaultLocale(groupId);
                    ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                    fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, _DEFAULT_FRAGMENT_COLLECTION_KEY, LanguageUtil.get((Locale)locale, (String)_DEFAULT_FRAGMENT_COLLECTION_KEY), "", serviceContext);
                }
                fragmentCollectionId = fragmentCollection.getFragmentCollectionId();
            }
            this._importFragmentEntries(userId, groupId, zipFile, fragmentCollectionId, orphanFragmentEntries, overwrite);
        }
        return this._invalidFragmentEntriesNames;
    }

    private FragmentCollection _addFragmentCollection(long groupId, String fragmentCollectionKey, String name, String description, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(groupId, fragmentCollectionKey);
        if (fragmentCollection == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            fragmentCollection = this._fragmentCollectionService.addFragmentCollection(groupId, fragmentCollectionKey, name, description, serviceContext);
        } else if (overwrite) {
            fragmentCollection = this._fragmentCollectionService.updateFragmentCollection(fragmentCollection.getFragmentCollectionId(), name, description);
        } else {
            throw new DuplicateFragmentCollectionKeyException(fragmentCollectionKey);
        }
        return fragmentCollection;
    }

    private FragmentEntry _addFragmentEntry(long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, String typeLabel, boolean overwrite) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentCollection.getGroupId(), fragmentEntryKey);
        if (fragmentEntry != null && !overwrite) {
            throw new DuplicateFragmentEntryKeyException(fragmentEntryKey);
        }
        int status = 0;
        try {
            this._fragmentEntryProcessorRegistry.validateFragmentEntryHTML(html);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            status = 2;
            this._invalidFragmentEntriesNames.add(name);
        }
        int type = FragmentConstants.getTypeFromLabel((String)StringUtil.toLowerCase((String)StringUtil.trim((String)typeLabel)));
        if (fragmentEntry == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            return this._fragmentEntryService.addFragmentEntry(fragmentCollection.getGroupId(), fragmentCollectionId, fragmentEntryKey, name, css, html, js, type, status, serviceContext);
        }
        return this._fragmentEntryService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), name, css, html, js, status);
    }

    private String _getContent(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return "";
        }
        return StringUtil.read((InputStream)zipFile.getInputStream(zipEntry));
    }

    private String _getFileName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(pos + 1);
        }
        return path;
    }

    private Map<String, FragmentCollectionFolder> _getFragmentCollectionFolderMap(ZipFile zipFile, long groupId, Map<String, String> orphanFragmentEntries) throws Exception {
        String fileName;
        ZipEntry zipEntry;
        HashMap<String, FragmentCollectionFolder> fragmentCollectionFolderMap = new HashMap<String, FragmentCollectionFolder>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentCollection(fileName = zipEntry.getName())) continue;
            fragmentCollectionFolderMap.put(this._getKey(zipFile, groupId, fileName), new FragmentCollectionFolder(fileName));
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !this._isFragmentEntry(fileName = zipEntry.getName())) continue;
            String fragmentCollectionPath = fileName;
            String fragmentCollectionKey = "";
            while (fragmentCollectionPath.length() > 0) {
                String fragmentCollectionFileName = (fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/") + 1)) + "collection.json";
                ZipEntry fragmentCollectionZipEntry = zipFile.getEntry(fragmentCollectionFileName);
                if (fragmentCollectionZipEntry != null) {
                    fragmentCollectionKey = this._getKey(zipFile, groupId, fragmentCollectionFileName);
                    break;
                }
                fragmentCollectionPath = fragmentCollectionPath.substring(0, fragmentCollectionPath.lastIndexOf("/"));
            }
            if (Validator.isNull((String)fragmentCollectionKey)) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            FragmentCollectionFolder fragmentCollectionFolder = (FragmentCollectionFolder)fragmentCollectionFolderMap.get(fragmentCollectionKey);
            if (fragmentCollectionFolder == null) {
                orphanFragmentEntries.put(this._getKey(zipFile, groupId, fileName), fileName);
                continue;
            }
            fragmentCollectionFolder.addFragmentEntry(this._getKey(zipFile, groupId, fileName), fileName);
        }
        return fragmentCollectionFolderMap;
    }

    private String _getFragmentEntryContent(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return "";
        }
        return StringUtil.read((InputStream)inputStream);
    }

    private InputStream _getFragmentEntryInputStream(ZipFile zipFile, String fileName, String contentPath) throws Exception {
        if (contentPath.startsWith("/")) {
            return this._getInputStream(zipFile, contentPath.substring(1));
        }
        if (contentPath.startsWith("./")) {
            contentPath = contentPath.substring(2);
        }
        String path = fileName.substring(0, fileName.lastIndexOf("/"));
        return this._getInputStream(zipFile, path + "/" + contentPath);
    }

    private InputStream _getInputStream(ZipFile zipFile, String fileName) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    private String _getKey(ZipFile zipFile, long groupId, String fileName) throws Exception {
        String key = "";
        if (fileName.lastIndexOf(47) != -1) {
            String path = fileName.substring(0, fileName.lastIndexOf(47));
            key = path.substring(path.lastIndexOf(47) + 1);
        } else if (fileName.equals("collection.json")) {
            JSONObject collectionJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentCollectionLocalService.generateFragmentCollectionKey(groupId, collectionJSONObject.getString("name"));
        } else if (fileName.equals("fragment.json")) {
            JSONObject fragmentJSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)zipFile.getInputStream(zipFile.getEntry(fileName))));
            key = this._fragmentEntryLocalService.generateFragmentEntryKey(groupId, fragmentJSONObject.getString("name"));
        }
        if (Validator.isNotNull((String)key)) {
            return key;
        }
        throw new IllegalArgumentException("Incorrect file name " + fileName);
    }

    private long _getPreviewFileEntryId(long userId, long groupId, ZipFile zipFile, long fragmentEntryId, String fileName, String contentPath) throws Exception {
        InputStream inputStream = this._getFragmentEntryInputStream(zipFile, fileName, contentPath);
        if (inputStream == null) {
            return 0L;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
        if (repository == null) {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)FragmentEntry.class.getName(), (long)fragmentEntryId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)repository.getDlFolderId(), (InputStream)inputStream, (String)(fragmentEntryId + "_preview." + FileUtil.getExtension((String)contentPath)), (String)MimeTypesUtil.getContentType((String)contentPath), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private void _importFragmentEntries(long userId, long groupId, ZipFile zipFile, long fragmentCollectionId, Map<String, String> fragmentEntries, boolean overwrite) throws Exception {
        for (Map.Entry<String, String> entry : fragmentEntries.entrySet()) {
            JSONObject jsonObject;
            String thumbnailPath;
            String name = entry.getKey();
            String css = "";
            String html = "";
            String js = "";
            String typeLabel = "";
            String fragmentJSON = this._getContent(zipFile, entry.getValue());
            if (Validator.isNotNull((String)fragmentJSON)) {
                JSONObject jsonObject2 = JSONFactoryUtil.createJSONObject((String)fragmentJSON);
                name = jsonObject2.getString("name");
                css = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("cssPath"));
                html = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("htmlPath"));
                js = this._getFragmentEntryContent(zipFile, entry.getValue(), jsonObject2.getString("jsPath"));
                typeLabel = jsonObject2.getString("type");
            }
            FragmentEntry fragmentEntry = this._addFragmentEntry(fragmentCollectionId, entry.getKey(), name, css, html, js, typeLabel, overwrite);
            if (!Validator.isNotNull((String)fragmentJSON)) continue;
            if (fragmentEntry.getPreviewFileEntryId() > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            }
            if (!Validator.isNotNull((String)(thumbnailPath = (jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentJSON)).getString("thumbnailPath")))) continue;
            long previewFileEntryId = this._getPreviewFileEntryId(userId, groupId, zipFile, fragmentEntry.getFragmentEntryId(), entry.getValue(), thumbnailPath);
            this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), previewFileEntryId);
        }
    }

    private void _importResources(long userId, long groupId, long fragmentCollectionId, long folderId, ZipFile zipFile) throws Exception {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<? extends ZipEntry> zipEntries = Collections.list(enumeration);
        Stream stream = zipEntries.stream();
        Set excludePaths = stream.filter(zipEntry -> {
            String name = zipEntry.getName();
            return name.endsWith("collection.json") || name.endsWith("fragment.json");
        }).flatMap(zipEntry -> {
            String name = zipEntry.getName();
            String path = name.substring(0, name.lastIndexOf("/") + 1);
            if (name.endsWith("collection.json")) {
                return Arrays.stream(new String[]{name});
            }
            try {
                String fragmentJSON = StringUtil.read((InputStream)zipFile.getInputStream((ZipEntry)zipEntry));
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentJSON);
                return Arrays.stream(new String[]{path + "fragment.json", path + jsonObject.getString("cssPath"), path + jsonObject.getString("htmlPath"), path + jsonObject.getString("jsPath"), path + jsonObject.getString("thumbnailPath")});
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read fragments.json file " + name), (Throwable)e);
                return Arrays.stream(new String[0]);
            }
        }).collect(Collectors.toSet());
        for (ZipEntry zipEntry2 : zipEntries) {
            Object[] paths = StringUtil.split((String)zipEntry2.getName(), (String)"/");
            if (!ArrayUtil.contains((Object[])paths, (Object)"resources") || excludePaths.contains(zipEntry2.getName())) continue;
            String fileName = this._getFileName(zipEntry2.getName());
            InputStream inputStream = this._getInputStream(zipFile, zipEntry2.getName());
            FileEntry fileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
            if (fileEntry != null) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
            }
            PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)FragmentCollection.class.getName(), (long)fragmentCollectionId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)folderId, (InputStream)inputStream, (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private boolean _isFragmentCollection(String fileName) {
        return Objects.equals(this._getFileName(fileName), "collection.json");
    }

    private boolean _isFragmentEntry(String fileName) {
        return Objects.equals(this._getFileName(fileName), "fragment.json");
    }

    private void _isValidFile(ZipFile zipFile) throws PortalException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!this._isFragmentCollection(zipEntry.getName()) && !this._isFragmentEntry(zipEntry.getName())) continue;
            return;
        }
        throw new InvalidFileException();
    }

    private class FragmentCollectionFolder {
        private final String _fileName;
        private final Map<String, String> _fragmentEntries;

        public FragmentCollectionFolder(String fileName) {
            this._fileName = fileName;
            this._fragmentEntries = new HashMap<String, String>();
        }

        public void addFragmentEntry(String key, String fileName) {
            this._fragmentEntries.put(key, fileName);
        }

        public String getFileName() {
            return this._fileName;
        }

        public Map<String, String> getFragmentEntries() {
            return this._fragmentEntries;
        }
    }
}

