/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.contributor;

import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={FragmentCollectionContributorTracker.class})
public class FragmentCollectionContributorTrackerImpl
implements FragmentCollectionContributorTracker {
    private static final int[] _SUPPORTED_FRAGMENT_TYPES = new int[]{1, 0};
    private final List<FragmentCollectionContributor> _fragmentCollectionContributors = new CopyOnWriteArrayList<FragmentCollectionContributor>();
    private final Map<String, FragmentEntry> _fragmentEntries = new ConcurrentHashMap<String, FragmentEntry>();

    @Deprecated
    public Map<String, FragmentEntry> getFragmentCollectionContributorEntries() {
        return this.getFragmentEntries();
    }

    public List<FragmentCollectionContributor> getFragmentCollectionContributors() {
        return new ArrayList<FragmentCollectionContributor>(this._fragmentCollectionContributors);
    }

    public Map<String, FragmentEntry> getFragmentEntries() {
        return new HashMap<String, FragmentEntry>(this._fragmentEntries);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setFragmentCollectionContributor(FragmentCollectionContributor fragmentCollectionContributor) {
        this._fragmentCollectionContributors.add(fragmentCollectionContributor);
        for (int type : _SUPPORTED_FRAGMENT_TYPES) {
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(type)) {
                this._fragmentEntries.put(fragmentEntry.getFragmentEntryKey(), fragmentEntry);
            }
        }
    }

    protected void unsetFragmentCollectionContributor(FragmentCollectionContributor fragmentCollectionContributor) {
        for (int type : _SUPPORTED_FRAGMENT_TYPES) {
            for (FragmentEntry fragmentEntry : fragmentCollectionContributor.getFragmentEntries(type)) {
                this._fragmentEntries.remove(fragmentEntry.getFragmentEntryKey());
            }
        }
        this._fragmentCollectionContributors.remove(fragmentCollectionContributor);
    }
}

