/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.Portlet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={PortletRegistry.class})
public class PortletRegistryImpl
implements PortletRegistry {
    private final Map<String, String> _portletNames = new ConcurrentHashMap<String, String>();

    public List<String> getFragmentEntryLinkPortletIds(FragmentEntryLink fragmentEntryLink) {
        ArrayList<String> portletIds = new ArrayList<String>();
        Document document = Jsoup.parseBodyFragment((String)fragmentEntryLink.getHtml());
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        for (Element element : document.select("*")) {
            String alias;
            String portletName;
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-") || Validator.isNull((String)(portletName = this.getPortletName(alias = StringUtil.replace((String)tagName, (String)"lfr-widget-", (String)""))))) continue;
            String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)(fragmentEntryLink.getNamespace() + element.attr("id")));
            portletIds.add(portletId);
        }
        return portletIds;
    }

    public List<String> getPortletAliases() {
        return new ArrayList<String>(this._portletNames.keySet());
    }

    public String getPortletName(String alias) {
        return this._portletNames.get(alias);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(com.liferay.fragment.entry.processor.portlet.alias=*)")
    protected void setPortlet(Portlet portlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.put(alias, portletName);
    }

    protected void unsetPortlet(Portlet portlet, Map<String, Object> properties) {
        String alias = MapUtil.getString(properties, (String)"com.liferay.fragment.entry.processor.portlet.alias");
        String portletName = MapUtil.getString(properties, (String)"javax.portlet.name");
        this._portletNames.remove(alias, portletName);
    }
}

