/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.processor;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.Collections;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorRegistry.class})
public class FragmentEntryProcessorRegistryImpl
implements FragmentEntryProcessorRegistry {
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerList<FragmentEntryProcessor, FragmentEntryProcessor> _serviceTrackerList;

    public JSONObject getDefaultEditableValuesJSONObject(String html) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            JSONObject defaultEditableValuesJSONObject = fragmentEntryProcessor.getDefaultEditableValuesJSONObject(html);
            if (defaultEditableValuesJSONObject == null) continue;
            Class<?> clazz = fragmentEntryProcessor.getClass();
            jsonObject.put(clazz.getName(), defaultEditableValuesJSONObject);
        }
        return jsonObject;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink) throws PortalException {
        return this.processFragmentEntryLinkHTML(fragmentEntryLink, "EDIT");
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String mode) throws PortalException {
        String html = fragmentEntryLink.getHtml();
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            html = fragmentEntryProcessor.processFragmentEntryLinkHTML(fragmentEntryLink, html, mode);
        }
        return html;
    }

    public void validateFragmentEntryHTML(String html) throws PortalException {
        for (FragmentEntryProcessor fragmentEntryProcessor : this._serviceTrackerList) {
            fragmentEntryProcessor.validateFragmentEntryHTML(html);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, FragmentEntryProcessor.class, Collections.reverseOrder(new PropertyServiceReferenceComparator("fragment.entry.processor.priority")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

