/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentPortletRenderer;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.util.FragmentPortletSetupUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=3"}, service={FragmentEntryProcessor.class})
public class PortletFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentPortletRenderer _fragmentPortletRenderer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    private final ResourceBundle _resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());

    public void deleteFragmentEntryLinkData(FragmentEntryLink fragmentEntryLink) {
        Document document = this._getDocument(fragmentEntryLink.getHtml());
        for (Element element : document.select("*")) {
            String alias;
            String portletName;
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-") || Validator.isNull((String)(portletName = this._portletRegistry.getPortletName(alias = StringUtil.replace((String)tagName, (String)"lfr-widget-", (String)""))))) continue;
            try {
                this._portletPreferencesLocalService.deletePortletPreferences(0L, 3, this._getPlid(fragmentEntryLink), this._getPortletId(portletName, fragmentEntryLink.getNamespace(), element.attr("id")));
            }
            catch (Exception exception) {}
        }
    }

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String alias : this._portletRegistry.getPortletAliases()) {
            StringBundler sb = new StringBundler(5);
            sb.append("<lfr-widget-");
            sb.append(alias);
            sb.append("></lfr-widget-");
            sb.append(alias);
            sb.append(">");
            JSONObject jsonObject = JSONUtil.put((String)"content", (Object)sb.toString()).put("name", "lfr-widget-" + alias);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        this.validateFragmentEntryHTML(html);
        String widgetHTML = this._renderWidgetHTML(fragmentEntryLink.getEditableValues(), fragmentEntryProcessorContext);
        if (Validator.isNotNull((String)widgetHTML)) {
            return widgetHTML;
        }
        Document document = this._getDocument(html);
        for (Element element : document.select("*")) {
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.replace((String)tagName, (String)"lfr-widget-", (String)"");
            String portletName = this._portletRegistry.getPortletName(alias);
            if (Validator.isNull((String)portletName)) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLink.getOriginalFragmentEntryLinkId());
            String id = element.attr("id");
            String defaultPreferences = "";
            if (originalFragmentEntryLink != null) {
                defaultPreferences = this._getPreferences(portletName, originalFragmentEntryLink, id, "");
            } else {
                Portlet portlet = this._portletLocalService.getPortletById(portletName);
                defaultPreferences = portlet.getDefaultPreferences();
            }
            String portletHTML = this._fragmentPortletRenderer.renderPortlet(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletName, this._getInstanceId(fragmentEntryLink.getNamespace(), id), this._getPreferences(portletName, fragmentEntryLink, id, defaultPreferences));
            Element portletElement = new Element("div");
            portletElement.attr("class", "portlet");
            portletElement.html(portletHTML);
            element.replaceWith((Node)portletElement);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, String mode, Locale locale, long[] segmentsExperienceIds, long previewClassPK, int previewType) throws PortalException {
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(null, null, mode, locale);
        defaultFragmentEntryProcessorContext.setPreviewClassPK(previewClassPK);
        defaultFragmentEntryProcessorContext.setPreviewType(previewType);
        defaultFragmentEntryProcessorContext.setSegmentsExperienceIds(segmentsExperienceIds);
        return this.processFragmentEntryLinkHTML(fragmentEntryLink, html, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
    }

    public void validateFragmentEntryHTML(String html) throws PortalException {
        Document document = this._getDocument(html);
        for (Element element : document.select("*")) {
            Elements elements;
            String htmlTagName = element.tagName();
            if (!StringUtil.startsWith((String)htmlTagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.replace((String)htmlTagName, (String)"lfr-widget-", (String)"");
            if (Validator.isNull((String)this._portletRegistry.getPortletName(alias))) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            String id = element.id();
            if (Validator.isNotNull((String)id) && !Validator.isAlphanumericName((String)id)) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"widget-id-must-contain-only-alphanumeric-characters", (Object)alias));
            }
            if (Validator.isNotNull((String)id)) {
                elements = document.select("#" + id);
                if (elements.size() > 1) {
                    throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"widget-id-must-be-unique"));
                }
                if (id.length() > GetterUtil.getInteger((String)"75")) {
                    throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"widget-id-cannot-exceed-x-characters", (Object)"75"));
                }
            }
            if ((elements = document.select(htmlTagName)).size() <= 1 || !Validator.isNull((String)id)) continue;
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"duplicate-widgets-within-the-same-fragment-must-have-an-id"));
        }
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _getInstanceId(String namespace, String id) {
        if (Validator.isNull((String)namespace)) {
            namespace = StringUtil.randomId();
        }
        return namespace + id;
    }

    private long _getPlid(FragmentEntryLink fragmentEntryLink) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        if (fragmentEntryLink.getClassNameId() == this._portal.getClassNameId(Layout.class)) {
            return fragmentEntryLink.getClassPK();
        }
        if (fragmentEntryLink.getClassNameId() == this._portal.getClassNameId(LayoutPageTemplateEntry.class) && (layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(fragmentEntryLink.getClassPK())) != null) {
            return layoutPageTemplateEntry.getPlid();
        }
        return 0L;
    }

    private String _getPortletId(String portletName, String namespace, String id) {
        String instanceId = this._getInstanceId(namespace, id);
        return PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)instanceId);
    }

    private String _getPreferences(String portletName, FragmentEntryLink fragmentEntryLink, String id, String defaultPreferences) throws PortalException {
        long groupId = fragmentEntryLink.getGroupId();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            groupId = serviceContext.getScopeGroupId();
        }
        Group group = this._groupLocalService.getGroup(groupId);
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)defaultPreferences);
        String portletId = this._getPortletId(portletName, fragmentEntryLink.getNamespace(), id);
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(group.getCompanyId(), 0L, 3, portletId);
        if (ListUtil.isNotEmpty((List)portletPreferencesList)) {
            jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)group.getCompanyId(), (long)0L, (int)3, (long)this._getPlid(fragmentEntryLink), (String)portletId, (String)defaultPreferences);
            this._updateLayoutPortletSetup(portletPreferencesList, jxPortletPreferences);
        }
        try {
            FragmentPortletSetupUtil.setPortletBareboneCSSClassName((javax.portlet.PortletPreferences)jxPortletPreferences);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        Document preferencesDocument = this._getDocument(PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        Element preferencesBody = preferencesDocument.body();
        return preferencesBody.html();
    }

    private String _renderWidgetHTML(String editableValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)editableValues);
        String portletId = jsonObject.getString("portletId");
        if (Validator.isNull((String)portletId)) {
            return "";
        }
        String instanceId = jsonObject.getString("instanceId");
        javax.portlet.PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)fragmentEntryProcessorContext.getHttpServletRequest(), (String)portletId);
        return this._fragmentPortletRenderer.renderPortlet(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletId, instanceId, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)portletPreferences));
    }

    private void _updateLayoutPortletSetup(List<PortletPreferences> portletPreferencesList, javax.portlet.PortletPreferences jxPortletPreferences) {
        String portletPreferencesXml = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
        long plid = 0L;
        if (jxPortletPreferences instanceof PortletPreferences) {
            PortletPreferences portletPreferences = (PortletPreferences)jxPortletPreferences;
            plid = portletPreferences.getPlid();
        }
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            if (plid != portletPreferences.getPlid() || Objects.equals(portletPreferences.getPreferences(), portletPreferencesXml)) continue;
            portletPreferences.setPreferences(portletPreferencesXml);
            this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
        }
    }
}

