/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=3"}, service={FragmentEntryProcessor.class})
public class PortletFragmentEntryProcessor
implements FragmentEntryProcessor {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    private final ResourceBundle _resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, String mode) throws PortalException {
        this.validateFragmentEntryHTML(html);
        Document document = this._getDocument(html);
        for (Element element : document.select("*")) {
            String tagName = element.tagName();
            if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.replace((String)tagName, (String)"lfr-widget-", (String)"");
            String portletName = this._portletRegistry.getPortletName(alias);
            if (Validator.isNull((String)portletName)) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            Element runtimeTagElement = new Element("@liferay_portlet.runtime", true);
            FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentEntryLink.getOriginalFragmentEntryLinkId());
            String portletPreferences = "";
            String instanceId = this._getInstanceId(fragmentEntryLink.getNamespace(), element.attr("id"));
            if (originalFragmentEntryLink != null) {
                String originalInstanceId = this._getInstanceId(originalFragmentEntryLink.getNamespace(), element.attr("id"));
                String defaultPreferences = this._getPreferences(portletName, originalFragmentEntryLink, originalInstanceId, "");
                portletPreferences = this._getPreferences(portletName, fragmentEntryLink, instanceId, defaultPreferences);
            } else {
                Portlet portlet = this._portletLocalService.getPortletById(portletName);
                portletPreferences = this._getPreferences(portletName, fragmentEntryLink, instanceId, portlet.getDefaultPreferences());
            }
            runtimeTagElement.attr("defaultPreferences", portletPreferences);
            runtimeTagElement.attr("instanceId", instanceId);
            runtimeTagElement.attr("persistSettings=false", true);
            runtimeTagElement.attr("portletName", portletName);
            Element portletElement = new Element("div");
            portletElement.attr("class", "portlet");
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
            Layout layout = themeDisplay.getLayout();
            if (PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)fragmentEntryLink.getGroupId(), (String)portletName, (String)"CONFIGURATION") && layout.isTypeControlPanel() && Objects.equals(mode, "EDIT")) {
                portletElement.appendChild((Node)this._getPortletTopperElement(portletName, instanceId));
            }
            portletElement.appendChild((Node)runtimeTagElement);
            element.replaceWith((Node)portletElement);
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    public void validateFragmentEntryHTML(String html) throws PortalException {
        Document document = this._getDocument(html);
        for (Element element : document.select("*")) {
            String htmlTagName = element.tagName();
            if (!StringUtil.startsWith((String)htmlTagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.replace((String)htmlTagName, (String)"lfr-widget-", (String)"");
            if (Validator.isNull((String)this._portletRegistry.getPortletName(alias))) {
                throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            if (!Validator.isNotNull((String)element.id()) || Validator.isAlphanumericName((String)element.id())) continue;
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"widget-id-must-contain-only-alphanumeric-characters", (Object)alias));
        }
    }

    private String _getConfigurationURL(String portletId) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        HttpServletRequest request = serviceContext.getRequest();
        PortletURL configurationURL = PortletProviderUtil.getPortletURL((HttpServletRequest)request, (String)"com.liferay.portlet.configuration.kernel.util.PortletConfigurationApplicationType$PortletConfiguration", (PortletProvider.Action)PortletProvider.Action.VIEW);
        configurationURL.setParameter("mvcPath", "/edit_configuration.jsp");
        configurationURL.setParameter("settingsScope", "portletInstance");
        configurationURL.setParameter("redirect", this._portal.getCurrentURL(request));
        configurationURL.setParameter("returnToFullPageURL", this._portal.getCurrentURL(request));
        configurationURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        configurationURL.setParameter("portletResource", portletId);
        configurationURL.setParameter("resourcePrimKey", PortletPermissionUtil.getPrimaryKey((long)serviceContext.getPlid(), (String)portletId));
        configurationURL.setWindowState(LiferayWindowState.POP_UP);
        StringBundler jsConfigurationURLSB = new StringBundler(11);
        jsConfigurationURLSB.append("Liferay.Portlet.openWindow({");
        jsConfigurationURLSB.append("bodyCssClass:'dialog-with-footer', ");
        jsConfigurationURLSB.append("destroyOnHide: true, portlet: '#p_p_id_");
        jsConfigurationURLSB.append(portletId);
        jsConfigurationURLSB.append("_', portletId: '");
        jsConfigurationURLSB.append(portletId);
        jsConfigurationURLSB.append("', title: '");
        jsConfigurationURLSB.append(LanguageUtil.get((HttpServletRequest)request, (String)"configuration"));
        jsConfigurationURLSB.append("', uri: '");
        jsConfigurationURLSB.append(configurationURL.toString());
        jsConfigurationURLSB.append("'}); return false;");
        return jsConfigurationURLSB.toString();
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private String _getInstanceId(String namespace, String id) {
        if (Validator.isNull((String)namespace)) {
            namespace = StringUtil.randomId();
        }
        return namespace + id;
    }

    private Element _getPortletMenuElement(String portletName, String instanceId) throws PortalException {
        String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)instanceId);
        Element menuElement = new Element("menu");
        menuElement.attr("class", "portlet-topper-toolbar");
        menuElement.attr("id", "portlet-topper-toolbar_" + portletId);
        menuElement.attr("type", "toolbar");
        Element buttonElement = new Element("button");
        buttonElement.attr("class", "btn btn-primary btn-sm");
        try {
            buttonElement.attr("onClick", this._getConfigurationURL(portletId));
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        buttonElement.attr("url", "javascript:;");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        buttonElement.text(LanguageUtil.get((HttpServletRequest)serviceContext.getRequest(), (String)"configure"));
        menuElement.appendChild((Node)buttonElement);
        return menuElement;
    }

    private Element _getPortletTopperElement(String portletName, String instanceId) throws PortalException {
        Element portletTopperElement = new Element("header");
        portletTopperElement.attr("class", "portlet-topper");
        Element portletTitleElement = new Element("div");
        portletTitleElement.attr("class", "portlet-title-default");
        Element portletNameElement = new Element("span");
        portletNameElement.attr("class", "portlet-name-text");
        String portletTitle = this._portal.getPortletTitle(portletName, LocaleThreadLocal.getThemeDisplayLocale());
        portletNameElement.text(portletTitle);
        portletTitleElement.appendChild((Node)portletNameElement);
        portletTopperElement.appendChild((Node)portletTitleElement);
        portletTopperElement.appendChild((Node)this._getPortletMenuElement(portletName, instanceId));
        return portletTopperElement;
    }

    private String _getPreferences(String portletName, FragmentEntryLink fragmentEntryLink, String instanceId, String defaultPreferences) throws PortalException {
        ServiceContext serviceContext;
        long groupId = fragmentEntryLink.getGroupId();
        if (groupId == 0L && (serviceContext = ServiceContextThreadLocal.getServiceContext()) != null) {
            groupId = serviceContext.getScopeGroupId();
        }
        Group group = this._groupLocalService.getGroup(groupId);
        long defaultPlid = this._portal.getControlPanelPlid(group.getCompanyId());
        String portletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)instanceId);
        javax.portlet.PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)defaultPreferences);
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(group.getCompanyId(), 0L, 3, portletId);
        if (ListUtil.isNotEmpty((List)portletPreferencesList)) {
            jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)group.getCompanyId(), (long)0L, (int)3, (long)defaultPlid, (String)portletId, (String)defaultPreferences);
            this._updateLayoutPortletSetup(portletPreferencesList, jxPortletPreferences);
        }
        Document preferencesDocument = this._getDocument(PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
        Element preferencesBody = preferencesDocument.body();
        return preferencesBody.html();
    }

    private void _updateLayoutPortletSetup(List<PortletPreferences> portletPreferencesList, javax.portlet.PortletPreferences jxPortletPreferences) {
        String portletPreferencesXml = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            if (Objects.equals(portletPreferences.getPreferences(), portletPreferencesXml)) continue;
            portletPreferences.setPreferences(portletPreferencesXml);
            this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
        }
    }
}

