/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.internal.util;

import com.liferay.asset.info.display.contributor.util.ContentAccessor;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.model.VersionedAssetEntry;
import com.liferay.fragment.entry.processor.util.FragmentEntryProcessorUtil;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorUtil.class})
public class FragmentEntryProcessorImpl
implements FragmentEntryProcessorUtil {
    private static final String _EDITABLE_VALUES_SEGMENTS_EXPERIENCE_ID_PREFIX = "segments-experience-id-";
    @Reference
    private InfoDisplayContributorTracker _infoDisplayContributorTracker;
    @Reference
    private Portal _portal;

    public String getEditableValue(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        if (this._isPersonalizationSupported(jsonObject)) {
            return this._getEditableValueBySegmentsExperienceAndLocale(jsonObject, locale, segmentsExperienceIds);
        }
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, String mode, Locale locale, long previewClassPK, int previewType) throws PortalException {
        String fieldId;
        String fieldValue;
        Map fieldsValues;
        AssetEntry assetEntry;
        if (!this.isMapped(jsonObject) && !this.isAssetDisplayPage(mode)) {
            return JSONFactoryUtil.createJSONObject();
        }
        long classNameId = jsonObject.getLong("classNameId");
        String className = this._portal.getClassName(classNameId);
        InfoDisplayContributor infoDisplayContributor = this._infoDisplayContributorTracker.getInfoDisplayContributor(className);
        if (infoDisplayContributor == null) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        long classPK = jsonObject.getLong("classPK");
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            return null;
        }
        InfoDisplayObjectProvider infoDisplayObjectProvider = infoDisplayContributor.getInfoDisplayObjectProvider(classPK);
        if (infoDisplayObjectProvider == null) {
            return null;
        }
        Object object = infoDisplayObjectProvider.getDisplayObject();
        if (object instanceof AssetEntry && previewClassPK == (assetEntry = (AssetEntry)object).getEntryId()) {
            classPK = previewClassPK;
        }
        if (MapUtil.isEmpty(fieldsValues = infoDisplaysFieldValues.get(classPK))) {
            if (object instanceof AssetEntry) {
                int versionType = 1;
                AssetEntry assetEntry2 = (AssetEntry)object;
                if (previewClassPK == assetEntry2.getEntryId()) {
                    versionType = previewType;
                }
                object = new VersionedAssetEntry(assetEntry2, versionType);
            }
            fieldsValues = infoDisplayContributor.getInfoDisplayFieldsValues(object, locale);
            infoDisplaysFieldValues.put(classPK, fieldsValues);
        }
        if ((fieldValue = fieldsValues.getOrDefault(fieldId = jsonObject.getString("fieldId"), null)) == null) {
            return null;
        }
        if (fieldValue instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)fieldValue;
            fieldValue = contentAccessor.getContent();
        }
        return fieldValue;
    }

    public boolean isAssetDisplayPage(String mode) {
        return Objects.equals(mode, "ASSET_DISPLAY_PAGE");
    }

    public boolean isMapped(JSONObject jsonObject) {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String fieldId = jsonObject.getString("fieldId");
        return classNameId > 0L && classPK > 0L && Validator.isNotNull((String)fieldId);
    }

    private String _getEditableValueByLocale(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)locale));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNull((String)value)) {
            value = jsonObject.getString("defaultValue");
        }
        return value;
    }

    private String _getEditableValueBySegmentsExperienceAndLocale(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        for (long segmentsExperienceId : segmentsExperienceIds) {
            String value = this._getSegmentsExperienceValue(jsonObject, locale, segmentsExperienceId);
            if (!Validator.isNotNull((String)value)) continue;
            return value;
        }
        return jsonObject.getString("defaultValue");
    }

    private String _getSegmentsExperienceValue(JSONObject jsonObject, Locale locale, Long segmentsExperienceId) {
        JSONObject segmentsExperienceJSONObject = jsonObject.getJSONObject(_EDITABLE_VALUES_SEGMENTS_EXPERIENCE_ID_PREFIX + segmentsExperienceId);
        if (segmentsExperienceJSONObject == null) {
            return "";
        }
        String value = segmentsExperienceJSONObject.getString(LanguageUtil.getLanguageId((Locale)locale));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        value = segmentsExperienceJSONObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        return "";
    }

    private boolean _isPersonalizationSupported(JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(_EDITABLE_VALUES_SEGMENTS_EXPERIENCE_ID_PREFIX)) continue;
            return true;
        }
        return false;
    }
}

