/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.internal.util;

import com.liferay.asset.info.display.contributor.util.ContentAccessor;
import com.liferay.asset.info.display.contributor.util.ContentAccessorUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FragmentEntryProcessorHelper.class})
public class FragmentEntryProcessorHelperImpl
implements FragmentEntryProcessorHelper {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoDisplayContributorTracker _infoDisplayContributorTracker;
    @Reference
    private Portal _portal;

    public String getEditableValue(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        if (this._isPersonalizationSupported(jsonObject)) {
            return this._getEditableValueBySegmentsExperienceAndLocale(jsonObject, locale, segmentsExperienceIds);
        }
        return this._getEditableValueByLocale(jsonObject, locale);
    }

    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String fieldId;
        String fieldValue;
        if (!this.isMapped(jsonObject) && !this.isAssetDisplayPage(fragmentEntryProcessorContext.getMode())) {
            return JSONFactoryUtil.createJSONObject();
        }
        long classNameId = jsonObject.getLong("classNameId");
        String className = this._portal.getClassName(classNameId);
        InfoDisplayContributor infoDisplayContributor = this._infoDisplayContributorTracker.getInfoDisplayContributor(className);
        if (infoDisplayContributor == null) {
            return null;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        long classPK = jsonObject.getLong("classPK");
        if (trashHandler != null && trashHandler.isInTrash(classPK)) {
            return null;
        }
        InfoDisplayObjectProvider infoDisplayObjectProvider = null;
        infoDisplayObjectProvider = fragmentEntryProcessorContext.getPreviewClassPK() > 0L && this._isSameClassedModel(classPK, fragmentEntryProcessorContext.getPreviewClassPK()) ? infoDisplayContributor.getPreviewInfoDisplayObjectProvider(fragmentEntryProcessorContext.getPreviewClassPK(), fragmentEntryProcessorContext.getPreviewType()) : infoDisplayContributor.getInfoDisplayObjectProvider(classPK);
        if (infoDisplayObjectProvider == null) {
            return null;
        }
        Map fieldsValues = infoDisplaysFieldValues.get(classPK);
        if (MapUtil.isEmpty(fieldsValues)) {
            Object object = infoDisplayObjectProvider.getDisplayObject();
            fieldsValues = infoDisplayContributor.getInfoDisplayFieldsValues(object, fragmentEntryProcessorContext.getLocale());
            infoDisplaysFieldValues.put(classPK, fieldsValues);
        }
        if ((fieldValue = fieldsValues.getOrDefault(fieldId = jsonObject.getString("fieldId"), null)) == null) {
            return null;
        }
        if (fieldValue instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)fieldValue;
            fieldValue = contentAccessor.getContent();
        }
        return fieldValue;
    }

    public Object getMappedValue(JSONObject jsonObject, Map<Long, Map<String, Object>> infoDisplaysFieldValues, String mode, Locale locale, long previewClassPK, int previewType) throws PortalException {
        DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(null, null, mode, locale);
        defaultFragmentEntryProcessorContext.setPreviewClassPK(previewClassPK);
        defaultFragmentEntryProcessorContext.setPreviewType(previewType);
        return this.getMappedValue(jsonObject, infoDisplaysFieldValues, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
    }

    public boolean isAssetDisplayPage(String mode) {
        return Objects.equals(mode, "ASSET_DISPLAY_PAGE");
    }

    public boolean isMapped(JSONObject jsonObject) {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        String fieldId = jsonObject.getString("fieldId");
        return classNameId > 0L && classPK > 0L && Validator.isNotNull((String)fieldId);
    }

    public String processTemplate(String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.put((Object)"writer", (Object)unsyncStringWriter);
        template.put((Object)"contentAccessorUtil", (Object)ContentAccessorUtil.getInstance());
        Optional fieldValuesOptional = fragmentEntryProcessorContext.getFieldValuesOptional();
        if (fieldValuesOptional.isPresent() && MapUtil.isNotEmpty((Map)((Map)fieldValuesOptional.get()))) {
            template.putAll((Map)fieldValuesOptional.get());
        }
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        template.processTemplate((Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    private String _getEditableValueByLocale(JSONObject jsonObject, Locale locale) {
        String value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)locale));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        value = jsonObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNull((String)value)) {
            value = jsonObject.getString("defaultValue");
        }
        return value;
    }

    private String _getEditableValueBySegmentsExperienceAndLocale(JSONObject jsonObject, Locale locale, long[] segmentsExperienceIds) {
        for (long segmentsExperienceId : segmentsExperienceIds) {
            String value = this._getSegmentsExperienceValue(jsonObject, locale, segmentsExperienceId);
            if (!Validator.isNotNull((String)value)) continue;
            return value;
        }
        return jsonObject.getString("defaultValue");
    }

    private String _getSegmentsExperienceValue(JSONObject jsonObject, Locale locale, Long segmentsExperienceId) {
        JSONObject segmentsExperienceJSONObject = jsonObject.getJSONObject("segments-experience-id-" + segmentsExperienceId);
        if (segmentsExperienceJSONObject == null) {
            return "";
        }
        String value = segmentsExperienceJSONObject.getString(LanguageUtil.getLanguageId((Locale)locale));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        value = segmentsExperienceJSONObject.getString(LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault()));
        if (Validator.isNotNull((String)value)) {
            return value;
        }
        return "";
    }

    private boolean _isPersonalizationSupported(JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("segments-experience-id-")) continue;
            return true;
        }
        return false;
    }

    private boolean _isSameClassedModel(long classPK, long previewClassPK) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchAssetEntry(previewClassPK);
        return assetEntry != null && assetEntry.getClassPK() == classPK;
    }
}

