/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.fragment.entry.processor.editable.parser.util;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

/**
 * @author Jürgen Kappler
 */
public class EditableElementParserUtil {

	public static void addAttribute(
		Element element, JSONObject configJSONObject, String attribute,
		String property) {

		if (configJSONObject == null) {
			return;
		}

		String value = configJSONObject.getString(property);

		if (Validator.isNotNull(value)) {
			element.attr(attribute, value);
		}
	}

	public static void addClass(
		Element element, JSONObject configJSONObject, String prefix,
		String property) {

		if (configJSONObject == null) {
			return;
		}

		String value = configJSONObject.getString(property);

		if (Validator.isNotNull(value)) {
			element.addClass(prefix + value);
		}
	}

	public static Element getDocumentBody(String value) {
		Document document = Jsoup.parseBodyFragment(value);

		Document.OutputSettings outputSettings = new Document.OutputSettings();

		outputSettings.prettyPrint(false);

		document.outputSettings(outputSettings);

		return document.body();
	}

}