/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.WebImage;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=image"}, service={EditableElementParser.class})
public class ImageEditableElementParser
implements EditableElementParser {
    private static final Log _log = LogFactoryUtil.getLog(ImageEditableElementParser.class);
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private Html _html;

    @Override
    public JSONObject getFieldTemplateConfigJSONObject(String fieldName, Locale locale, Object fieldValue) {
        String alt = "";
        Number fileEntryId = 0;
        if (fieldValue instanceof JSONObject) {
            JSONObject fieldValueJSONObject = (JSONObject)fieldValue;
            alt = fieldValueJSONObject.getString("alt");
            if (Validator.isNotNull((String)alt) && JSONUtil.isValid((String)alt)) {
                JSONObject altJSONObject = fieldValueJSONObject.getJSONObject("alt");
                alt = altJSONObject.getString(LocaleUtil.toLanguageId((Locale)locale));
            }
            if (fieldValueJSONObject.has("className") && fieldValueJSONObject.has("classPK")) {
                fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId(fieldValueJSONObject.getString("className"), fieldValueJSONObject.getLong("classPK"));
            } else if (fieldValueJSONObject.has("fileEntryId")) {
                fileEntryId = fieldValueJSONObject.getLong("fileEntryId");
            }
        } else if (fieldValue instanceof WebImage) {
            WebImage webImage = (WebImage)fieldValue;
            Optional altInfoLocalizedValueOptional = webImage.getAltInfoLocalizedValueOptional();
            if (altInfoLocalizedValueOptional.isPresent()) {
                InfoLocalizedValue infoLocalizedValue = (InfoLocalizedValue)altInfoLocalizedValueOptional.get();
                alt = (String)infoLocalizedValue.getValue(locale);
            }
            fileEntryId = this._fragmentEntryProcessorHelper.getFileEntryId(webImage);
        }
        return JSONUtil.put((String)"alt", (Object)alt).put("fileEntryId", (Object)fileEntryId);
    }

    @Override
    public String getValue(Element element) {
        Elements elements = element.getElementsByTag("img");
        if (ListUtil.isEmpty((List)elements)) {
            return "";
        }
        Element replaceableElement = (Element)elements.get(0);
        String src = replaceableElement.attr("src");
        if (Validator.isNull((String)src.trim())) {
            return StringBundler.concat((String[])new String[]{"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAJ", "CAYAAAA7KqwyAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs", "4c6QAAAARnQU1BAACxjwv8YQUAAAAkSURBVHgB7cxBEQAACAIwtH8P", "zw52kxD8OBZgNXsPQUOUwCIgAz0DHTyygaAAAAAASUVORK5CYII="});
        }
        return src;
    }

    @Override
    public String parseFieldValue(Object fieldValue) {
        if (fieldValue instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)fieldValue;
            return GetterUtil.getString((String)jsonObject.getString("url"));
        }
        if (fieldValue instanceof String && Validator.isNotNull((Object)fieldValue)) {
            return GetterUtil.getString((Object)fieldValue);
        }
        if (fieldValue instanceof WebImage) {
            WebImage webImage = (WebImage)fieldValue;
            return GetterUtil.getString((String)webImage.getUrl());
        }
        return "";
    }

    @Override
    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    @Override
    public void replace(Element element, String value, JSONObject configJSONObject) {
        String imageLink;
        Elements elements = element.getElementsByTag("img");
        if (ListUtil.isEmpty((List)elements)) {
            return;
        }
        Element replaceableElement = (Element)elements.get(0);
        long fileEntryId = 0L;
        if (JSONUtil.isValid((String)value)) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
                fileEntryId = jsonObject.getLong("fileEntryId");
                value = jsonObject.getString("url");
            }
            catch (JSONException jsonException) {
                _log.error((Object)("Unable to parse JSON value " + value));
                value = "";
            }
        } else {
            fileEntryId = configJSONObject.getLong("fileEntryId");
        }
        value = value.trim();
        if (fileEntryId > 0L) {
            replaceableElement.attr("data-fileentryid", String.valueOf(fileEntryId));
            if (configJSONObject != null && configJSONObject.has("imageConfiguration")) {
                this._setImageConfiguration(replaceableElement, configJSONObject.getJSONObject("imageConfiguration"));
            }
        }
        Matcher matcher = _pattern.matcher(replaceableElement.attr("src"));
        if (Validator.isNotNull((String)value) && !matcher.matches()) {
            replaceableElement.attr("src", this._html.unescape(value));
        }
        if (configJSONObject == null) {
            return;
        }
        String alt = configJSONObject.getString("alt");
        if (Validator.isNotNull((String)alt) && JSONUtil.isValid((String)alt)) {
            JSONObject altJSONObject = configJSONObject.getJSONObject("alt");
            Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
            alt = altJSONObject.getString(LocaleUtil.toLanguageId((Locale)locale));
        }
        if (Validator.isNotNull((String)alt)) {
            replaceableElement.attr("alt", StringUtil.trim((String)this._html.unescape(alt)));
        }
        if (Validator.isNull((String)(imageLink = configJSONObject.getString("imageLink")))) {
            return;
        }
        String imageTarget = configJSONObject.getString("imageTarget");
        if (StringUtil.equalsIgnoreCase((String)imageTarget, (String)"_parent") || StringUtil.equalsIgnoreCase((String)imageTarget, (String)"_top")) {
            imageTarget = "_self";
        }
        Element linkElement = new Element("a");
        linkElement.attr("href", imageLink);
        if (Validator.isNotNull((String)imageTarget)) {
            linkElement.attr("target", imageTarget);
        }
        linkElement.html(element.html());
        element.html(linkElement.outerHtml());
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        Elements elements = element.getElementsByTag("img");
        if (elements.size() != 1) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"each-editable-image-element-must-contain-an-img-tag", (Object[])new Object[]{"<em>", "</em>"}, (boolean)false));
        }
    }

    private void _setImageConfiguration(Element element, JSONObject imageConfigurationJSONObject) {
        for (ViewportSize viewportSize : _viewportSizes) {
            String imageConfiguration = imageConfigurationJSONObject.getString(viewportSize.getViewportSizeId());
            if (Validator.isNull((String)imageConfiguration) || Objects.equals(imageConfiguration, "auto")) continue;
            element.attr("data-" + viewportSize.getViewportSizeId() + "-configuration", imageConfiguration);
        }
    }
}

